/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.request;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.protocol.http.WebResponse;

public final class WebErrorCodeResponseTarget
implements IRequestTarget {
    private final int errorCode;
    private final String message;

    public WebErrorCodeResponseTarget(int errorCode) {
        this(errorCode, null);
    }

    public WebErrorCodeResponseTarget(int errorCode, String message) {
        this.errorCode = errorCode;
        this.message = message;
    }

    public void respond(RequestCycle requestCycle) {
        WebResponse webResponse = ((WebRequestCycle)requestCycle).getWebResponse();
        HttpServletResponse httpServletResponse = webResponse.getHttpServletResponse();
        try {
            if (this.message != null) {
                httpServletResponse.sendError(this.errorCode, this.message);
            } else {
                httpServletResponse.sendError(this.errorCode);
            }
        }
        catch (IOException e) {
            throw new WicketRuntimeException(e);
        }
    }

    public final int getErrorCode() {
        return this.errorCode;
    }

    public final String getMessage() {
        return this.message;
    }

    public void detach(RequestCycle requestCycle) {
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof WebErrorCodeResponseTarget) {
            WebErrorCodeResponseTarget that = (WebErrorCodeResponseTarget)obj;
            if (this.errorCode == that.errorCode) {
                equal = this.message != null ? that.message != null && this.message.equals(that.message) : that.message == null;
            }
        }
        return equal;
    }

    public int hashCode() {
        int result = "WebErrorCodeResponseTarget".hashCode();
        result += this.message != null ? this.message.hashCode() : 0;
        return 17 * (result += this.errorCode);
    }

    public String toString() {
        return "[WebErrorCodeResponseTarget@" + this.hashCode() + " errorCode=" + this.getErrorCode() + (this.message != null ? " (" + this.message + ")" : "]");
    }
}

