/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.request;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IPageMap;
import org.apache.wicket.IRedirectListener;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.IResourceListener;
import org.apache.wicket.Page;
import org.apache.wicket.PageMap;
import org.apache.wicket.PageParameters;
import org.apache.wicket.PageReference;
import org.apache.wicket.Request;
import org.apache.wicket.RequestContext;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.behavior.IActivePageBehaviorListener;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.IBehaviorListener;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.protocol.http.WicketURLDecoder;
import org.apache.wicket.protocol.http.portlet.PortletRequestContext;
import org.apache.wicket.protocol.http.request.InvalidUrlException;
import org.apache.wicket.request.IRequestCodingStrategy;
import org.apache.wicket.request.IRequestTargetMountsInfo;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.coding.AbstractRequestTargetUrlCodingStrategy;
import org.apache.wicket.request.target.coding.IRequestTargetUrlCodingStrategy;
import org.apache.wicket.request.target.coding.WebRequestEncoder;
import org.apache.wicket.request.target.component.BookmarkableListenerInterfaceRequestTarget;
import org.apache.wicket.request.target.component.IBookmarkablePageRequestTarget;
import org.apache.wicket.request.target.component.IPageRequestTarget;
import org.apache.wicket.request.target.component.PageReferenceRequestTarget;
import org.apache.wicket.request.target.component.listener.IListenerInterfaceRequestTarget;
import org.apache.wicket.request.target.resource.ISharedResourceRequestTarget;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.PrependingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.string.UrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebRequestCodingStrategy
implements IRequestCodingStrategy,
IRequestTargetMountsInfo {
    public static final String NAME_SPACE = "wicket:";
    public static final String INTERFACE_PARAMETER_NAME = "wicket:interface";
    public static final String BEHAVIOR_ID_PARAMETER_NAME = "wicket:behaviorId";
    public static final String BOOKMARKABLE_PAGE_PARAMETER_NAME = "wicket:bookmarkablePage";
    public static final String PAGEMAP = "wicket:pageMapName";
    public static final String DEFAULT_PAGEMAP_NAME = "wicketdef";
    public static final String RESOURCES_PATH_PREFIX = "resources/";
    public static final String IGNORE_IF_NOT_ACTIVE_PARAMETER_NAME = "wicket:ignoreIfNotActive";
    private static final Logger log = LoggerFactory.getLogger(WebRequestCodingStrategy.class);
    private final MountsMap mountsOnPath;

    public WebRequestCodingStrategy() {
        this(new Settings());
    }

    public WebRequestCodingStrategy(Settings settings) {
        if (settings == null) {
            throw new IllegalArgumentException("Argument [[settings]] cannot be null");
        }
        this.mountsOnPath = new MountsMap(settings.areMountsCaseSensitive());
    }

    public final RequestParameters decode(Request request) {
        try {
            RequestParameters parameters = new RequestParameters();
            String pathInfo = this.getRequestPath(request);
            parameters.setPath(pathInfo);
            parameters.setPageMapName(request.getParameter(PAGEMAP));
            this.addInterfaceParameters(request, parameters);
            this.addBookmarkablePageParameters(request, parameters);
            this.addResourceParameters(request, parameters);
            if (request.getParameter(IGNORE_IF_NOT_ACTIVE_PARAMETER_NAME) != null) {
                parameters.setOnlyProcessIfPathActive(true);
            }
            Map<String, String[]> map = request.getParameterMap();
            Iterator<String> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String key = iterator.next();
                if (!key.startsWith(NAME_SPACE)) continue;
                iterator.remove();
            }
            parameters.setParameters(map);
            parameters.setQueryString(request.getQueryString());
            return parameters;
        }
        catch (WicketRuntimeException e) {
            throw new InvalidUrlException(e);
        }
    }

    public final CharSequence encode(RequestCycle requestCycle, IRequestTarget requestTarget) {
        CharSequence url = this.pathForTarget(requestTarget);
        RequestContext requestContext = RequestContext.get();
        boolean portletRequest = requestContext.isPortletRequest();
        boolean sharedResourceURL = false;
        boolean isAjax = ((WebRequestCycle)requestCycle).getWebRequest().isAjax();
        boolean skipRelativePathPrefix = false;
        if (url != null && !portletRequest) {
            skipRelativePathPrefix = isAjax;
        } else if (requestTarget instanceof IBookmarkablePageRequestTarget) {
            url = portletRequest ? ((PortletRequestContext)requestContext).encodeRenderURL(url == null ? this.encode(requestCycle, (IBookmarkablePageRequestTarget)requestTarget) : url, true) : requestContext.encodeRenderURL(url == null ? this.encode(requestCycle, (IBookmarkablePageRequestTarget)requestTarget) : url);
        } else if (requestTarget instanceof ISharedResourceRequestTarget) {
            url = requestContext.encodeSharedResourceURL(url == null ? this.encode(requestCycle, (ISharedResourceRequestTarget)requestTarget) : url);
            sharedResourceURL = true;
        } else if (requestTarget instanceof PageReferenceRequestTarget) {
            url = this.encode(requestCycle, (PageReferenceRequestTarget)requestTarget);
        } else if (requestTarget instanceof IListenerInterfaceRequestTarget) {
            if (url == null) {
                url = this.encode(requestCycle, (IListenerInterfaceRequestTarget)requestTarget);
            }
            if (portletRequest) {
                IListenerInterfaceRequestTarget iliRequestTarget = (IListenerInterfaceRequestTarget)requestTarget;
                RequestListenerInterface rli = iliRequestTarget.getRequestListenerInterface();
                if (IResourceListener.class.isAssignableFrom(rli.getMethod().getDeclaringClass()) || IBehaviorListener.class.isAssignableFrom(rli.getMethod().getDeclaringClass())) {
                    url = requestContext.encodeResourceURL(url);
                } else if (IRedirectListener.class.isAssignableFrom(rli.getMethod().getDeclaringClass())) {
                    url = isAjax ? ((PortletRequestContext)requestContext).encodeRenderURL(url, true) : requestContext.encodeRenderURL(url);
                } else {
                    PortletRequestContext prc = (PortletRequestContext)requestContext;
                    boolean forceActionURL = prc.isAjax();
                    if (forceActionURL) {
                        List<IBehavior> behaviors = iliRequestTarget.getTarget().getBehaviors();
                        int size = behaviors.size();
                        for (int i = 0; i < size; ++i) {
                            if (!AbstractAjaxBehavior.class.isAssignableFrom(behaviors.get(i).getClass())) continue;
                            forceActionURL = false;
                            break;
                        }
                    }
                    url = prc.encodeActionURL(url, forceActionURL);
                }
            }
        } else if (url == null) {
            if (requestTarget instanceof IPageRequestTarget) {
                return this.encode(requestCycle, (IPageRequestTarget)requestTarget);
            }
            url = this.doEncode(requestCycle, requestTarget);
        }
        if (url != null) {
            String result = null;
            if (!UrlUtils.isRelative(((Object)url).toString()) || !sharedResourceURL && portletRequest || skipRelativePathPrefix) {
                result = ((Object)url).toString();
            } else {
                PrependingStringBuffer prepender = new PrependingStringBuffer(((Object)url).toString());
                prepender.prepend(requestCycle.getRequest().getRelativePathPrefixToWicketHandler());
                result = prepender.toString();
                if (result.length() == 0) {
                    result = "./";
                }
            }
            return requestCycle.getOriginalResponse().encodeURL(result);
        }
        return null;
    }

    public CharSequence encode(CharSequence url) {
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRequestTargetUrlCodingStrategy[] listMounts() {
        MountsMap mountsMap = this.mountsOnPath;
        synchronized (mountsMap) {
            return this.mountsOnPath.strategies().toArray(new IRequestTargetUrlCodingStrategy[this.mountsOnPath.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRequestTargetUrlCodingStrategy urlCodingStrategyForPath(String path) {
        MountsMap mountsMap = this.mountsOnPath;
        synchronized (mountsMap) {
            if (path == null) {
                return this.mountsOnPath.strategyForMount(null);
            }
            IRequestTargetUrlCodingStrategy strategy = this.mountsOnPath.strategyForPath(path);
            if (strategy != null && !(strategy instanceof PassThroughUrlCodingStrategy)) {
                return strategy;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void mount(IRequestTargetUrlCodingStrategy encoder) {
        if (encoder == null) {
            throw new IllegalArgumentException("Argument encoder must not be null");
        }
        String path = encoder.getMountPath();
        if (path == null) {
            throw new IllegalArgumentException("Argument path must not be null");
        }
        if (path.equals("/") || path.equals("")) {
            throw new IllegalArgumentException("The mount path '/' is reserved for the application home page");
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        MountsMap mountsMap = this.mountsOnPath;
        synchronized (mountsMap) {
            if (this.mountsOnPath.strategyForMount(path) != null) {
                throw new WicketRuntimeException(path + " is already mounted for " + this.mountsOnPath.strategyForMount(path));
            }
            this.mountsOnPath.mount(path, encoder);
        }
    }

    public void addIgnoreMountPath(String path) {
        this.mount(new PassThroughUrlCodingStrategy(path));
    }

    public final CharSequence pathForTarget(IRequestTarget requestTarget) {
        IRequestTargetUrlCodingStrategy encoder = this.getMountEncoder(requestTarget);
        if (encoder != null) {
            return encoder.encode(requestTarget);
        }
        return null;
    }

    public final IRequestTarget targetForRequest(RequestParameters requestParameters) {
        IRequestTargetUrlCodingStrategy encoder = this.urlCodingStrategyForPath(requestParameters.getPath());
        if (encoder == null) {
            return null;
        }
        return encoder.decode(requestParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unmount(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument path must be not-null");
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        MountsMap mountsMap = this.mountsOnPath;
        synchronized (mountsMap) {
            this.mountsOnPath.unmount(path);
        }
    }

    protected void addBookmarkablePageParameters(Request request, RequestParameters parameters) {
        String requestString = request.getParameter(BOOKMARKABLE_PAGE_PARAMETER_NAME);
        if (requestString != null) {
            String[] components = Strings.split(requestString, ':');
            if (components.length != 2) {
                throw new WicketRuntimeException("Invalid bookmarkablePage parameter: " + requestString + ", expected: 'pageMapName:pageClassName'");
            }
            String pageMapName = components[0];
            parameters.setPageMapName(pageMapName.length() == 0 ? PageMap.DEFAULT_NAME : pageMapName);
            String pageClassName = components[1];
            parameters.setBookmarkablePageClass(pageClassName);
        }
    }

    protected void addInterfaceParameters(Request request, RequestParameters parameters) {
        WebRequestCodingStrategy.addInterfaceParameters(request.getParameter(INTERFACE_PARAMETER_NAME), parameters);
    }

    public static void addInterfaceParameters(String interfaceParameter, RequestParameters parameters) {
        int urlDepth;
        if (interfaceParameter == null) {
            return;
        }
        String[] pathComponents = Strings.split(interfaceParameter, ':');
        if (pathComponents.length < 6) {
            throw new WicketRuntimeException("Internal error parsing wicket:interface = " + interfaceParameter);
        }
        String versionNumberString = null;
        try {
            versionNumberString = pathComponents[pathComponents.length - 4];
            int versionNumber = Strings.isEmpty(versionNumberString) ? 0 : Integer.parseInt(versionNumberString);
            parameters.setVersionNumber(versionNumber);
        }
        catch (NumberFormatException e) {
            throw new WicketRuntimeException("Internal error parsing wicket:interface = " + interfaceParameter + "; wrong format for page version argument. Expected a number but was '" + versionNumberString + "'", e);
        }
        String pageMapName = pathComponents[0];
        parameters.setPageMapName(pageMapName.length() == 0 ? PageMap.DEFAULT_NAME : pageMapName);
        String urlDepthString = pathComponents[pathComponents.length - 1];
        try {
            urlDepth = Strings.isEmpty(urlDepthString) ? -1 : Integer.parseInt(urlDepthString);
        }
        catch (NumberFormatException e) {
            throw new WicketRuntimeException("Internal error parsing wicket:interface = " + interfaceParameter + "; wrong format for url depth argument. Expected a number but was '" + urlDepthString + "'", e);
        }
        parameters.setUrlDepth(urlDepth);
        String behaviourId = pathComponents[pathComponents.length - 2];
        parameters.setBehaviorId(behaviourId.length() != 0 ? behaviourId : null);
        String interfaceName = pathComponents[pathComponents.length - 3];
        parameters.setInterfaceName(interfaceName.length() != 0 ? interfaceName : IRedirectListener.INTERFACE.getName());
        int start = pageMapName.length() + 1;
        int end = interfaceParameter.length() - behaviourId.length() - interfaceName.length() - versionNumberString.length() - urlDepthString.length() - 4;
        String componentPath = interfaceParameter.substring(start, end);
        parameters.setComponentPath(componentPath);
    }

    protected void addResourceParameters(Request request, RequestParameters parameters) {
        String pathInfo = request.getPath();
        if (pathInfo != null && pathInfo.startsWith(RESOURCES_PATH_PREFIX)) {
            int ix = RESOURCES_PATH_PREFIX.length();
            if (pathInfo.length() > ix) {
                StringBuffer path = new StringBuffer(WicketURLDecoder.PATH_INSTANCE.decode(pathInfo.substring(ix)));
                int ixSemiColon = path.indexOf(";");
                if (ixSemiColon != -1) {
                    int ixEnd = path.indexOf("?");
                    if (ixEnd == -1) {
                        ixEnd = path.length();
                    }
                    path.delete(ixSemiColon, ixEnd);
                }
                parameters.setResourceKey(path.toString());
            }
        }
    }

    protected String doEncode(RequestCycle requestCycle, IRequestTarget requestTarget) {
        return null;
    }

    protected CharSequence encode(RequestCycle requestCycle, IBookmarkablePageRequestTarget requestTarget) {
        PageParameters parameters;
        AppendingStringBuffer url = new AppendingStringBuffer(64);
        Class<? extends Page> pageClass = requestTarget.getPageClass();
        Application application = Application.get();
        String pageMapName = requestTarget.getPageMapName();
        if (pageMapName == null) {
            Page currentPage;
            IPageMap pageMap;
            IRequestTarget currentTarget = requestCycle.getRequestTarget();
            pageMapName = currentTarget instanceof IPageRequestTarget ? ((pageMap = (currentPage = ((IPageRequestTarget)currentTarget).getPage()).getPageMap()).isDefault() ? "" : pageMap.getName()) : "";
        }
        WebRequestEncoder encoder = new WebRequestEncoder(url);
        if (!application.getHomePage().equals(pageClass) || !"".equals(pageMapName) || application.getHomePage().equals(pageClass) && requestTarget instanceof BookmarkableListenerInterfaceRequestTarget) {
            encoder.addValue(BOOKMARKABLE_PAGE_PARAMETER_NAME, pageMapName + ':' + pageClass.getName());
        }
        if ((parameters = requestTarget.getPageParameters()) != null) {
            for (String key : parameters.keySet()) {
                String[] values = parameters.getStringArray(key);
                if (values == null) continue;
                for (int i = 0; i < values.length; ++i) {
                    encoder.addValue(key, values[i]);
                }
            }
        }
        return url;
    }

    protected CharSequence encode(RequestCycle requestCycle, ISharedResourceRequestTarget requestTarget) {
        String sharedResourceKey = requestTarget.getResourceKey();
        if (sharedResourceKey == null || sharedResourceKey.trim().length() == 0) {
            return "";
        }
        AppendingStringBuffer buffer = new AppendingStringBuffer(sharedResourceKey.length());
        buffer.append(RESOURCES_PATH_PREFIX);
        buffer.append(sharedResourceKey);
        Map<String, ?> map = requestTarget.getRequestParameters().getParameters();
        if (map != null && map.size() > 0) {
            buffer.append('?');
            Iterator<Map.Entry<String, ?>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, ?> entry = it.next();
                buffer.append(entry.getKey());
                buffer.append('=');
                buffer.append(entry.getValue());
                if (!it.hasNext()) continue;
                buffer.append('&');
            }
        }
        return buffer;
    }

    protected CharSequence encode(RequestCycle requestCycle, PageReferenceRequestTarget requestTarget) {
        PageReference id = requestTarget.getPageReference();
        AppendingStringBuffer url = new AppendingStringBuffer(64);
        url.append('?');
        url.append(INTERFACE_PARAMETER_NAME);
        url.append('=');
        if (!Objects.equal(PageMap.DEFAULT_NAME, id.getPageMapName())) {
            url.append(id.getPageMapName());
        }
        url.append(':');
        url.append(id.getPageNumber());
        url.append(':');
        url.append(id.getPageVersion());
        url.append(':');
        url.append(':');
        url.append(':');
        return url;
    }

    protected CharSequence encode(RequestCycle requestCycle, IListenerInterfaceRequestTarget requestTarget) {
        RequestListenerInterface rli = requestTarget.getRequestListenerInterface();
        AppendingStringBuffer url = new AppendingStringBuffer(64);
        url.append('?');
        url.append(INTERFACE_PARAMETER_NAME);
        url.append('=');
        Component component = requestTarget.getTarget();
        Page page = component.getPage();
        IPageMap pageMap = page.getPageMap();
        if (!pageMap.isDefault()) {
            url.append(pageMap.getName());
        }
        url.append(':');
        url.append(component.getPath());
        url.append(':');
        int versionNumber = component.getPage().getCurrentVersionNumber();
        if (!rli.getRecordsPageVersion()) {
            url.append(-1);
        } else if (versionNumber > 0) {
            url.append(versionNumber);
        }
        url.append(':');
        String listenerName = rli.getName();
        if (!IRedirectListener.INTERFACE.getName().equals(listenerName)) {
            url.append(listenerName);
        }
        url.append(':');
        RequestParameters params = requestTarget.getRequestParameters();
        if (params != null && params.getBehaviorId() != null) {
            url.append(params.getBehaviorId());
        }
        url.append(':');
        if (params != null && params.getUrlDepth() != 0) {
            url.append(params.getUrlDepth());
        }
        if (IActivePageBehaviorListener.INTERFACE.getName().equals(listenerName)) {
            url.append(url.indexOf("?") > -1 ? "&" : "?").append(IGNORE_IF_NOT_ACTIVE_PARAMETER_NAME).append("=true");
        }
        return url;
    }

    protected CharSequence encode(RequestCycle requestCycle, IPageRequestTarget requestTarget) {
        Page page = requestTarget.getPage();
        CharSequence urlRedirect = page.urlFor(IRedirectListener.INTERFACE);
        Session.get().touch(page);
        return urlRedirect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRequestTargetUrlCodingStrategy getMountEncoder(IRequestTarget requestTarget) {
        MountsMap mountsMap = this.mountsOnPath;
        synchronized (mountsMap) {
            for (IRequestTargetUrlCodingStrategy encoder : this.mountsOnPath.strategies()) {
                if (!encoder.matches(requestTarget)) continue;
                return encoder;
            }
        }
        return null;
    }

    protected String getRequestPath(Request request) {
        return request.getPath();
    }

    public static final String encodePageMapName(String pageMapName) {
        if (Strings.isEmpty(pageMapName)) {
            return DEFAULT_PAGEMAP_NAME;
        }
        return pageMapName;
    }

    public static String decodePageMapName(String pageMapName) {
        if (DEFAULT_PAGEMAP_NAME.equals(pageMapName)) {
            return null;
        }
        return pageMapName;
    }

    public String rewriteStaticRelativeUrl(String string) {
        return UrlUtils.rewriteToContextRelative(string, RequestCycle.get().getRequest());
    }

    private static class PassThroughUrlCodingStrategy
    extends AbstractRequestTargetUrlCodingStrategy {
        public PassThroughUrlCodingStrategy(String path) {
            super(path);
        }

        public IRequestTarget decode(RequestParameters requestParameters) {
            return null;
        }

        public CharSequence encode(IRequestTarget requestTarget) {
            return null;
        }

        public boolean matches(IRequestTarget requestTarget) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MountsMap {
        private static final long serialVersionUID = 1L;
        private final boolean caseSensitiveMounts;
        private final TreeMap<String, IRequestTargetUrlCodingStrategy> map = new TreeMap(LENGTH_COMPARATOR);
        private static final Comparator<String> LENGTH_COMPARATOR = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                String lhs = o1;
                String rhs = o2;
                return rhs.compareTo(lhs);
            }
        };

        public MountsMap(boolean caseSensitiveMounts) {
            this.caseSensitiveMounts = caseSensitiveMounts;
        }

        public IRequestTargetUrlCodingStrategy strategyForPath(String path) {
            if (path == null) {
                throw new IllegalArgumentException("Argument [[path]] cannot be null");
            }
            if (!this.caseSensitiveMounts) {
                path = path.toLowerCase();
            }
            for (Map.Entry<String, IRequestTargetUrlCodingStrategy> entry : this.map.entrySet()) {
                IRequestTargetUrlCodingStrategy strategy;
                String key = entry.getKey();
                if (!path.startsWith(key) || !(strategy = entry.getValue()).matches(path, this.caseSensitiveMounts)) continue;
                return strategy;
            }
            return null;
        }

        public int size() {
            return this.map.size();
        }

        public Collection<IRequestTargetUrlCodingStrategy> strategies() {
            return this.map.values();
        }

        public void unmount(String mount) {
            if (!this.caseSensitiveMounts && mount != null) {
                mount = mount.toLowerCase();
            }
            this.map.remove(mount);
        }

        public IRequestTargetUrlCodingStrategy strategyForMount(String mount) {
            if (!this.caseSensitiveMounts && mount != null) {
                mount = mount.toLowerCase();
            }
            return this.map.get(mount);
        }

        public IRequestTargetUrlCodingStrategy mount(String mount, IRequestTargetUrlCodingStrategy encoder) {
            if (!this.caseSensitiveMounts && mount != null) {
                mount = mount.toLowerCase();
            }
            return this.map.put(mount, encoder);
        }
    }

    public static class Settings {
        private boolean mountsCaseSensitive = true;

        public void setMountsCaseSensitive(boolean mountsCaseSensitive) {
            this.mountsCaseSensitive = mountsCaseSensitive;
        }

        public boolean areMountsCaseSensitive() {
            return this.mountsCaseSensitive;
        }
    }
}

