/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.coding;

import java.util.Collections;
import java.util.Map;
import org.apache.wicket.protocol.http.WicketURLDecoder;
import org.apache.wicket.protocol.http.WicketURLEncoder;
import org.apache.wicket.protocol.http.servlet.AbortWithWebErrorCodeException;
import org.apache.wicket.request.target.coding.IMountableRequestTargetUrlCodingStrategy;
import org.apache.wicket.request.target.coding.IRequestTargetUrlCodingStrategy;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRequestTargetUrlCodingStrategy
implements IRequestTargetUrlCodingStrategy,
IMountableRequestTargetUrlCodingStrategy {
    private static final Logger log = LoggerFactory.getLogger(AbstractRequestTargetUrlCodingStrategy.class);
    private final String mountPath;

    public AbstractRequestTargetUrlCodingStrategy(String mountPath) {
        if (mountPath == null) {
            throw new IllegalArgumentException("Mount path cannot be null or empty");
        }
        String string = this.mountPath = mountPath.startsWith("/") ? mountPath.substring(1) : mountPath;
        if (this.mountPath.startsWith("resources/") || this.mountPath.equals("resources")) {
            throw new IllegalArgumentException("Mount path cannot be under '/resources'");
        }
    }

    @Override
    public final String getMountPath() {
        return this.mountPath;
    }

    protected void appendParameters(AppendingStringBuffer url, Map<String, ?> parameters) {
        if (parameters != null && parameters.size() > 0) {
            for (Map.Entry<String, ?> entry1 : parameters.entrySet()) {
                Object value = entry1.getValue();
                if (value == null) continue;
                if (value instanceof String[]) {
                    String[] values;
                    for (String value1 : values = (String[])value) {
                        this.appendValue(url, entry1.getKey().toString(), value1);
                    }
                    continue;
                }
                this.appendValue(url, entry1.getKey().toString(), value.toString());
            }
        }
    }

    private void appendValue(AppendingStringBuffer url, String key, String value) {
        String escapedValue = this.urlEncodePathComponent(value);
        if (!Strings.isEmpty(escapedValue)) {
            if (!url.endsWith("/")) {
                url.append("/");
            }
            url.append(key).append("/").append(escapedValue);
        }
    }

    protected ValueMap decodeParameters(String urlFragment, Map<String, ?> urlParameters) {
        if (urlFragment.startsWith("/")) {
            urlFragment = urlFragment.substring(1);
        }
        if (urlFragment.length() > 0 && urlFragment.endsWith("/")) {
            urlFragment = urlFragment.substring(0, urlFragment.length() - 1);
        }
        if (urlFragment.length() == 0) {
            return new ValueMap(urlParameters != null ? urlParameters : Collections.EMPTY_MAP);
        }
        String[] pairs = urlFragment.split("/");
        if (pairs.length % 2 != 0) {
            log.warn("URL fragment has unmatched key/value pairs, responding with 404. Fragment: " + urlFragment);
            throw new AbortWithWebErrorCodeException(404);
        }
        ValueMap parameters = new ValueMap();
        for (int i = 0; i < pairs.length; i += 2) {
            String value = pairs[i + 1];
            value = this.urlDecodePathComponent(value);
            parameters.add(pairs[i], value);
        }
        if (urlParameters != null) {
            parameters.putAll(urlParameters);
        }
        return parameters;
    }

    protected String urlEncodePathComponent(String string) {
        return WicketURLEncoder.PATH_INSTANCE.encode(string);
    }

    protected String urlDecodePathComponent(String value) {
        return WicketURLDecoder.PATH_INSTANCE.decode(value);
    }

    protected String urlEncodeQueryComponent(String string) {
        return WicketURLEncoder.QUERY_INSTANCE.encode(string);
    }

    protected String urlDecodeQueryComponent(String value) {
        return WicketURLDecoder.QUERY_INSTANCE.decode(value);
    }

    @Deprecated
    protected String urlDecode(String value) {
        return this.urlDecodePathComponent(value);
    }

    @Deprecated
    protected String urlEncode(String string) {
        return this.urlEncodePathComponent(string);
    }

    @Override
    public boolean matches(String path, boolean caseSensitive) {
        String remainder;
        return Strings.startsWith(path, this.mountPath, caseSensitive) && ((remainder = path.substring(this.mountPath.length())).length() == 0 || remainder.startsWith("/"));
    }
}

