/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.coding;

import java.util.Map;
import org.apache.wicket.PageParameters;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.request.WebRequestCodingStrategy;
import org.apache.wicket.request.target.coding.HybridUrlCodingStrategy;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.value.ValueMap;

public class IndexedHybridUrlCodingStrategy
extends HybridUrlCodingStrategy {
    public IndexedHybridUrlCodingStrategy(String mountPath, Class pageClass) {
        super(mountPath, pageClass);
    }

    public IndexedHybridUrlCodingStrategy(String mountPath, Class pageClass, boolean redirectOnBookmarkableRequest) {
        super(mountPath, pageClass, redirectOnBookmarkableRequest);
    }

    protected void appendParameters(AppendingStringBuffer url, Map parameters) {
        int i = 0;
        while (parameters.containsKey(String.valueOf(i))) {
            String value = (String)parameters.get(String.valueOf(i));
            if (!url.endsWith("/")) {
                url.append("/");
            }
            url.append(this.urlEncodePathComponent(value));
            ++i;
        }
        String pageMap = (String)parameters.get("wicket:pageMapName");
        if (pageMap != null) {
            ++i;
            pageMap = WebRequestCodingStrategy.encodePageMapName(pageMap);
            if (!url.endsWith("/")) {
                url.append("/");
            }
            url.append("wicket:pageMapName").append("/").append(this.urlEncodePathComponent(pageMap));
        }
        if (i != parameters.size()) {
            throw new WicketRuntimeException("Not all parameters were encoded. Make sure all parameter names are integers in consecutive order starting with zero. Current parameter names are: " + parameters.keySet().toString());
        }
    }

    protected ValueMap decodeParameters(String urlFragment, Map urlParameters) {
        PageParameters params = new PageParameters();
        if (urlFragment == null) {
            return params;
        }
        if (urlFragment.startsWith("/")) {
            urlFragment = urlFragment.substring(1);
        }
        if (urlFragment.length() > 0 && urlFragment.endsWith("/")) {
            urlFragment = urlFragment.substring(0, urlFragment.length() - 1);
        }
        if (urlFragment.length() > 0) {
            String[] parts = urlFragment.split("/");
            for (int i = 0; i < parts.length; ++i) {
                if ("wicket:pageMapName".equals(parts[i])) {
                    params.put("wicket:pageMapName", (Object)WebRequestCodingStrategy.decodePageMapName(this.urlDecodePathComponent(parts[++i])));
                    continue;
                }
                params.put(String.valueOf(i), (Object)this.urlDecodePathComponent(parts[i]));
            }
        }
        return params;
    }
}

