/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.component;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.request.target.component.BookmarkablePageRequestTarget;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarkableListenerInterfaceRequestTarget
extends BookmarkablePageRequestTarget {
    private final String componentPath;
    private final String interfaceName;

    public BookmarkableListenerInterfaceRequestTarget(String pageMapName, Class<? extends Page> pageClass, PageParameters pageParameters, String componentPath, String interfaceName, int versionNumber) {
        super(pageMapName, pageClass, pageParameters);
        this.componentPath = componentPath;
        this.interfaceName = interfaceName;
    }

    public BookmarkableListenerInterfaceRequestTarget(String pageMapName, Class<? extends Page> pageClass, PageParameters pageParameters, Component component, RequestListenerInterface listenerInterface) {
        this(pageMapName, pageClass, pageParameters, component.getPath(), listenerInterface.getName(), component.getPage().getCurrentVersionNumber());
        int version = component.getPage().getCurrentVersionNumber();
        this.setPage(component.getPage());
        AppendingStringBuffer param = new AppendingStringBuffer(4 + this.componentPath.length() + this.interfaceName.length());
        if (pageMapName != null) {
            param.append(pageMapName);
        }
        param.append(':');
        param.append(this.getComponentPath());
        param.append(':');
        if (version != 0) {
            param.append(version);
        }
        param.append(':');
        param.append(this.getInterfaceName());
        param.append(':');
        param.append(':');
        pageParameters.put("wicket:interface", (Object)param.toString());
    }

    @Override
    public void processEvents(RequestCycle requestCycle) {
        RequestListenerInterface listenerInterface;
        Page page = this.getPage();
        if (page == null) {
            page = Session.get().getPage(this.getPageMapName(), this.componentPath, -1);
            if (page != null && page.getClass() == this.getPageClass()) {
                this.setPage(page);
            } else {
                page = this.getPage(requestCycle);
            }
        }
        if (page == null) {
            throw new PageExpiredException("Request cannot be processed. The target page does not exist anymore.");
        }
        String pageRelativeComponentPath = Strings.afterFirstPathComponent(this.componentPath, ':');
        Component component = page.get(pageRelativeComponentPath);
        if (component == null) {
            page.prepareForRender(false);
            component = page.get(pageRelativeComponentPath);
            if (component == null) {
                throw new WicketRuntimeException("unable to find component with path " + pageRelativeComponentPath + " on stateless page " + page + " it could be that the component is inside a repeater make your component return false in getStatelessHint()");
            }
        }
        if ((listenerInterface = RequestListenerInterface.forName(this.interfaceName)) == null) {
            throw new WicketRuntimeException("unable to find listener interface " + this.interfaceName);
        }
        listenerInterface.invoke(page, component);
    }

    @Override
    public void respond(RequestCycle requestCycle) {
        Page page = this.getPage(requestCycle);
        if (requestCycle.isRedirect() && !page.isPageStateless()) {
            requestCycle.redirectTo(page);
        } else {
            page.renderPage();
        }
    }

    public String getComponentPath() {
        return this.componentPath;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }
}

