/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.io;

import java.io.IOException;
import java.io.Reader;
import org.apache.wicket.util.io.Streams;

public final class FullyBufferedReader {
    private final String input;
    private int inputPosition;
    private int lineNumber = 1;
    private int columnNumber = 1;
    private int lastLineCountIndex;
    private int positionMarker;

    public FullyBufferedReader(Reader reader) throws IOException {
        this.input = Streams.readString(reader);
    }

    public final CharSequence getSubstring(int toPos) {
        if (toPos < 0) {
            toPos = this.input.length();
        } else if (toPos < this.positionMarker) {
            return "";
        }
        return this.input.subSequence(this.positionMarker, toPos);
    }

    public final CharSequence getSubstring(int fromPos, int toPos) {
        return this.input.subSequence(fromPos, toPos);
    }

    public final int getPosition() {
        return this.inputPosition;
    }

    public final void setPositionMarker(int pos) {
        this.positionMarker = pos;
    }

    public String toString() {
        return this.input;
    }

    public final void countLinesTo(int end) {
        for (int i = this.lastLineCountIndex; i < end; ++i) {
            char ch = this.input.charAt(i);
            if (ch == '\n') {
                this.columnNumber = 1;
                ++this.lineNumber;
                continue;
            }
            if (ch == '\r') continue;
            ++this.columnNumber;
        }
        this.lastLineCountIndex = end;
    }

    public final int find(char ch) {
        return this.input.indexOf(ch, this.inputPosition);
    }

    public final int find(char ch, int startPos) {
        return this.input.indexOf(ch, startPos);
    }

    public final int find(String str) {
        return this.input.indexOf(str, this.inputPosition);
    }

    public final int find(String str, int startPos) {
        return this.input.indexOf(str, startPos);
    }

    public final void setPosition(int pos) {
        this.inputPosition = pos;
    }

    public final int getColumnNumber() {
        return this.columnNumber;
    }

    public final int getLineNumber() {
        return this.lineNumber;
    }

    public final int size() {
        return this.input.length();
    }

    public final char charAt(int pos) {
        return this.input.charAt(pos);
    }
}

