/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.license;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import junit.framework.Assert;
import org.apache.wicket.util.license.ApacheLicenseHeaderTestCase;
import org.apache.wicket.util.license.ILicenseHeaderHandler;
import org.apache.wicket.util.string.Strings;

abstract class AbstractLicenseHeaderHandler
implements ILicenseHeaderHandler {
    protected static final String LINE_ENDING = System.getProperty("line.separator");
    private String licenseHeader;
    private final String[] ignoreFiles;

    public AbstractLicenseHeaderHandler(String[] ignoreFiles) {
        this.ignoreFiles = ignoreFiles;
    }

    public String[] getIgnoreFiles() {
        return this.ignoreFiles;
    }

    public boolean addLicenseHeader(File file) {
        System.out.println("Not supported yet.");
        return false;
    }

    public String getLicenseType(File file) {
        return null;
    }

    protected abstract String getLicenseHeaderFilename();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLicenseHeader() {
        if (Strings.isEmpty(this.licenseHeader)) {
            BufferedReader lineNumberReader = null;
            InputStream inputStream = null;
            InputStreamReader inputStreamReader = null;
            try {
                inputStream = ApacheLicenseHeaderTestCase.class.getResourceAsStream(this.getLicenseHeaderFilename());
                inputStreamReader = new InputStreamReader(inputStream);
                lineNumberReader = new LineNumberReader(inputStreamReader);
                StringBuffer header = new StringBuffer();
                String line = ((LineNumberReader)lineNumberReader).readLine();
                while (line != null) {
                    header.append(line);
                    header.append(LINE_ENDING);
                    line = ((LineNumberReader)lineNumberReader).readLine();
                }
                this.licenseHeader = header.toString().trim();
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
            finally {
                if (lineNumberReader != null) {
                    try {
                        lineNumberReader.close();
                    }
                    catch (Exception e) {}
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception e) {}
                }
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return this.licenseHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String extractLicenseHeader(File file, int start, int length) {
        StringBuffer header = new StringBuffer();
        BufferedReader lineNumberReader = null;
        try {
            FileReader fileReader = new FileReader(file);
            lineNumberReader = new LineNumberReader(fileReader);
            for (int i = start; i < length; ++i) {
                header.append(((LineNumberReader)lineNumberReader).readLine());
                header.append(LINE_ENDING);
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (lineNumberReader != null) {
                try {
                    lineNumberReader.close();
                }
                catch (IOException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        }
        return header.toString().trim();
    }

    protected void prependLicenseHeader(File file) {
        try {
            String content = new org.apache.wicket.util.file.File(file).readString();
            content = this.getLicenseHeader() + LINE_ENDING + content;
            new org.apache.wicket.util.file.File(file).write(content);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

