/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.template;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.Resource;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.SharedResources;
import org.apache.wicket.util.resource.AbstractStringResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.template.TextTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextTemplateSharedResourceFactory {
    private static final long serialVersionUID = 1L;
    private final WeakReference<Class<?>> scopeRef;
    private final TextTemplate template;

    public TextTemplateSharedResourceFactory(TextTemplate template) {
        this(template, Application.class);
    }

    public TextTemplateSharedResourceFactory(TextTemplate template, Class<?> scope) {
        this.template = template;
        this.scopeRef = new WeakReference(scope);
    }

    public ResourceReference resourceReference(Map<String, Object> variables) {
        String uniqueName = this.sharedResourceName(variables);
        final String templateValue = this.template.asString(variables);
        SharedResources sharedResources = Application.get().getSharedResources();
        Resource resource = sharedResources.get(uniqueName);
        if (resource == null) {
            Resource newResource = new Resource(){
                private static final long serialVersionUID = 1L;

                public IResourceStream getResourceStream() {
                    return new AbstractStringResourceStream(){
                        private static final long serialVersionUID = 1L;

                        protected String getString() {
                            return templateValue;
                        }
                    };
                }
            };
            sharedResources.add(uniqueName, newResource);
        }
        return new ResourceReference((Class)this.scopeRef.get(), uniqueName);
    }

    protected String sharedResourceName(Map<String, Object> variables) {
        StringBuffer buffer = new StringBuffer();
        Iterator<Object> iterator = variables.values().iterator();
        while (iterator.hasNext()) {
            String value = iterator.next().toString();
            buffer.append(this.encodeValue(value));
            if (!iterator.hasNext()) continue;
            buffer.append('-');
        }
        return buffer.toString();
    }

    private String encodeValue(String value) {
        StringBuffer buffer = new StringBuffer(value.length() + 10);
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                buffer.append(c);
                continue;
            }
            buffer.append('%');
            buffer.append(Integer.toHexString(c));
        }
        return buffer.toString();
    }
}

