/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import winstone.Launcher;
import winstone.Logger;
import winstone.WinstoneOutputStream;
import winstone.WinstoneResponse;

public class WinstoneResponseWriter
extends PrintWriter {
    private WinstoneOutputStream outputStream;
    private WinstoneResponse response;
    private int bytesBuffered;

    public WinstoneResponseWriter(WinstoneOutputStream out, WinstoneResponse response) throws UnsupportedEncodingException {
        super((Writer)new OutputStreamWriter((OutputStream)out, response.getCharacterEncoding()), false);
        this.outputStream = out;
        this.response = response;
        this.bytesBuffered = 0;
    }

    public void write(int c) {
        super.write(c);
        this.appendByteCount("" + (char)c);
    }

    public void write(char[] buf, int off, int len) {
        super.write(buf, off, len);
        if (buf != null) {
            this.appendByteCount(new String(buf, off, len));
        }
    }

    public void write(String s, int off, int len) {
        super.write(s, off, len);
        if (s != null) {
            this.appendByteCount(s.substring(off, len));
        }
    }

    protected void appendByteCount(String input) {
        try {
            this.bytesBuffered += input.getBytes(this.response.getCharacterEncoding()).length;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void println() {
        super.println();
        this.simulateAutoFlush();
    }

    public void flush() {
        super.flush();
        this.bytesBuffered = 0;
    }

    protected void simulateAutoFlush() {
        String contentLengthHeader = this.response.getHeader("Content-Length");
        if (contentLengthHeader != null && this.outputStream.getOutputStreamLength() + this.bytesBuffered >= Integer.parseInt(contentLengthHeader)) {
            Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WinstoneResponseWriter.AutoFlush", new String[]{contentLengthHeader, this.outputStream.getOutputStreamLength() + this.bytesBuffered + ""});
            this.flush();
        }
    }
}

