package jp.bne.deno.ordermaid.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;

@Entity
public class MenuSet implements Serializable, Cloneable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 2264379813337979754L;

	@Id
	@GeneratedValue
	private int menuSetId;

	private int sort;

	private String menuSetName;

	public MenuSet() {

	}

	public MenuSet(int sort, String menuSetName) {
		this.sort = sort;
		this.menuSetName = menuSetName;
	}

	public int getMenuSetId() {
		return menuSetId;
	}

	public void setMenuSetId(int menuSetId) {
		this.menuSetId = menuSetId;
	}

	public int getSort() {
		return sort;
	}

	public void setSort(int sort) {
		this.sort = sort;
	}

	public String getMenuSetName() {
		return menuSetName;
	}

	public void setMenuSetName(String menuSetName) {
		this.menuSetName = menuSetName;
	}

	public Set<MenuType> getMenuTypes() {
		return menuTypes;
	}

	public void setMenuTypes(Set<MenuType> menuTypes) {
		this.menuTypes = menuTypes;
	}

	@OneToMany(mappedBy = "menuSet")
	@JoinColumn(name = "menusetid")
	private Set<MenuType> menuTypes = new HashSet<MenuType>();

}
