package jp.bne.deno.ordermaid.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;

/**
 * システム管理マスタ.
 * 
 * @author hasegawt
 * 
 */
@Entity
public class SystemItem implements Serializable, Cloneable {
	private static final long serialVersionUID = 1L;

	public SystemItem() {

	}

	public SystemItem(String key, String value) {
		this.key = key;
		this.value = value;
	}

	public SystemItem(String key, String value, String note) {
		this.key = key;
		this.value = value;
		this.note = note;
	}

	@Id
	@Column(length = 20)
	private String key;

	private String value;

	private String note;

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}
}
