package jp.bne.deno.ordermaid.print;

import java.awt.Color;
import java.io.IOException;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.pdf.BaseFont;

/**
 * PDFドキュメント作成用の基底クラス.
 * 
 * @author hasegawt
 * 
 */
public abstract class DocumentBuilder {
	protected BaseFont gothic;

	protected Font gothic8;

	protected Font gothic8i;

	protected Font gothic8b;

	protected Font gothic8bi;

	protected Font gothic8w;

	protected Font gothic10;

	protected Font gothic10i;

	protected Font gothic10b;

	protected Font gothic10bi;

	protected Font gothic10w;

	protected Font gothic12;

	protected Font gothic12w;

	protected Font gothic14;

	protected Font gothic14w;

	protected Font gothic16;

	protected Font gothic16w;

	protected Font gothic18;

	protected Font gothic18w;

	protected Font gothic18b;

	/**
	 * コンストラクタ.
	 */
	public DocumentBuilder() {
		// フォントの初期化.
		try {
			gothic = BaseFont.createFont("HGRGE.TTC,1", BaseFont.IDENTITY_H,
					BaseFont.CACHED);
		} catch (DocumentException e) {
			e.printStackTrace();
			throw new RuntimeException(e.getMessage());
		} catch (IOException e) {
			e.printStackTrace();
			throw new RuntimeException(e.getMessage());
		}
		gothic8 = new Font(gothic, 8);
		gothic8i = new Font(gothic, 8, Font.ITALIC);
		gothic8b = new Font(gothic, 8, Font.BOLD);
		gothic8bi = new Font(gothic, 8, Font.BOLDITALIC);
		gothic8w = new Font(gothic, 8);
		gothic8w.setColor(Color.WHITE);

		gothic10 = new Font(gothic, 10);
		gothic12 = new Font(gothic, 12);
		gothic10i = new Font(gothic, 10, Font.ITALIC);
		gothic10b = new Font(gothic, 10, Font.BOLD);
		gothic10bi = new Font(gothic, 10, Font.BOLDITALIC);
		gothic10w = new Font(gothic, 10);
		gothic10w.setColor(Color.WHITE);
		gothic12 = new Font(gothic, 12);
		gothic12w = new Font(gothic, 12);
		gothic12w.setColor(Color.WHITE);
		gothic14 = new Font(gothic, 14);
		gothic14w = new Font(gothic, 14);
		gothic14w.setColor(Color.WHITE);
		gothic16 = new Font(gothic, 16);
		gothic16w = new Font(gothic, 16);
		gothic16w.setColor(Color.WHITE);
		gothic18 = new Font(gothic, 18);
		gothic18w = new Font(gothic, 18);
		gothic18w.setColor(Color.WHITE);
		gothic18b = new Font(gothic, 18, Font.BOLD);

	}
}
