package jp.bne.deno.ordermaid.report;

import java.util.List;

import jp.bne.deno.ordermaid.common.ExcelReportBuilder;
import jp.bne.deno.ordermaid.dao.OrderTable;
import jp.bne.deno.ordermaid.model.SalesSummary;
import jxl.write.Label;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;

import com.google.inject.Inject;

public class TotalReportBuilder extends ExcelReportBuilder {

	@Inject
	OrderTable orderTable;

	/**
	 * 主処理実行.
	 */
	public void run() {
		setSheet("集計");
		List<SalesSummary> list = orderTable.summarySales();
		try {
			int col = 0;
			int row = 1;
			for (SalesSummary data : list) {
				// 行を編集する.
				sheet.addCell(new Label(col++, row, data.getOrderDate()));
				sheet
						.addCell(new Label(col++, row, data.getAmount()
								.toString()));
				sheet
						.addCell(new Label(col++, row, data.getGroups()
								.toString()));
				sheet
						.addCell(new Label(col++, row, data.getPrice()
								.toString()));
				// 次の行に進む.
				col = 0;
				row++;
			}
			writeOut();
		} catch (RowsExceededException e) {
			e.printStackTrace();
		} catch (WriteException e) {
			e.printStackTrace();
		}
	}
}
