package jp.bne.deno.ordermaid.view;

import java.util.ArrayList;
import java.util.List;

import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.RadioChoice;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.CompoundPropertyModel;

import com.google.inject.Inject;

import jp.bne.deno.ordermaid.dao.MenuItemTable;
import jp.bne.deno.ordermaid.dao.MenuTypeTable;
import jp.bne.deno.ordermaid.model.MenuItem;
import jp.bne.deno.ordermaid.model.MenuType;
import jp.bne.deno.ordermaid.model.OrderDetail;
import jp.bne.deno.ordermaid.model.OrderItem;
import jp.bne.deno.ordermaid.view.helper.SexDropDownChoice;
import jp.bne.deno.ordermaid.view.helper.SheetsDropDownChoice;

/**
 * @author hasegawt. 注文明細画面.
 */
public class OrderDetailPage extends BasePage {

	final OrderDetail detail;

	private MenuType menuTypes = new MenuType();

	List<MenuItem> menu = new ArrayList<MenuItem>();

	@Inject
	MenuItemTable menuItemTable;

	@Inject
	MenuTypeTable menuTypeTable;

	public OrderDetailPage(final OrderDetail arg) {
		this.detail = arg;
		Form<OrderDetailPage> form = new Form<OrderDetailPage>("form");
		form.setModel(new CompoundPropertyModel<OrderDetailPage>(this));
		form.add(new FeedbackPanel("feedback"));

		form.add(new SexDropDownChoice("detail.sex").setRequired(true));
		form.add(new SheetsDropDownChoice("detail.sheetId").setRequired(true));
		form.add(new Label("detail.sumPrice"));
		form.add(new Label("menuTypes.menuType"));
		form.add(new CheckBox("detail.takeOut"));

		// 注文済みアイテム
		final ListView<OrderItem> itemListView = new ListView<OrderItem>(
				"detail.items") {
			@Override
			protected void populateItem(ListItem<OrderItem> item) {
				final OrderItem orderItem = item.getModelObject();
				item.setModel(new CompoundPropertyModel<OrderItem>(orderItem));
				item.add(new Label("orderName"));
				item.add(new Label("price"));
				Button cancel = new Button("cancel") {
					public void onSubmit() {
						orderItem.setCancel(true);
					}
				};
				cancel.setEnabled(!orderItem.isCancel());
				item.add(cancel);
			}
		};
		form.add(itemListView);

		// メニューリスト・選択ラジオ
		menu = menuItemTable.findByTypeId(menuTypes.getMenuTypeId());
		final ListView<MenuItem> menuListView = new ListView<MenuItem>("menu") {
			@Override
			protected void populateItem(ListItem<MenuItem> item) {
				final MenuItem menuItem = item.getModelObject();
				item.add(new Label("menuName", menuItem.getMenuName()));
				item.add(new Button("select") {
					public void onSubmit() {
						detail.getItems().add(new OrderItem(menuItem));
					}
				});
			}
		};
		form.add(menuListView);

		RadioChoice<MenuType> choice = new RadioChoice<MenuType>("menuTypes") {
			@Override
			protected void onSelectionChanged(Object newSelection) {
				super.onSelectionChanged(newSelection);
				MenuType type = (MenuType) newSelection;
				menu = menuItemTable.findByTypeId(type.getMenuTypeId());
				menuListView.setList(menu);
			}

			protected boolean wantOnSelectionChangedNotifications() {
				return true;
			}
		};
		choice.setSuffix("");
		choice.setChoices(menuTypeTable.findAll());
		choice.setChoiceRenderer(new IChoiceRenderer<MenuType>() {
			// @Override
			public Object getDisplayValue(MenuType item) {
				return item.getMenuType();
			}

			// @Override
			public String getIdValue(MenuType item, int idx) {
				return item.getMenuType();
			}
		});
		form.add(choice);

		form.add(new Button("submit") {
			public void onSubmit() {
				setResponsePage(new OrderPage(detail.getOrder()));
			}
		});
		add(form);
	}

}
