package jp.bne.deno.ordermaid.view;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import jp.bne.deno.ordermaid.dao.OrderTable;
import jp.bne.deno.ordermaid.model.OrderData;
import jp.bne.deno.ordermaid.model.OrderDetail;
import jp.bne.deno.ordermaid.model.SalesData;

import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.CompoundPropertyModel;
import com.google.inject.Inject;

/**
 * @author hasegawt. メニュー画面
 */
public class SalesDaySummaryPage extends BasePage {

	@Inject
	OrderTable orderTable;

	String year;

	String month;

	String day;

	private List<SalesData> list = new ArrayList<SalesData>();

	public SalesDaySummaryPage(String year, String month, String day) {

		this.year = year;
		this.month = month;
		this.day = day;

		Form<SalesDaySummaryPage> form = new Form<SalesDaySummaryPage>("form",
				new CompoundPropertyModel<SalesDaySummaryPage>(this));
		form.add(new FeedbackPanel("feedback"));
		add(form);

		// 日付ドロップダウン作成
		List<String> years = new ArrayList<String>();
		List<String> months = new ArrayList<String>();
		List<String> days = new ArrayList<String>();
		final Calendar current = Calendar.getInstance();

		int baseYear = current.get(Calendar.YEAR);
		for (int i = baseYear - 2; i < baseYear + 2; i++) {
			years.add(Integer.toString(i));
		}
		year = Integer.toString(baseYear);
		for (int i = 1; i < 13; i++) {
			months.add(Integer.toString(i));
		}
		month = Integer.toString(current.get(Calendar.MONTH) + 1);

		for (int i = 1; i < 31; i++) {
			days.add(Integer.toString(i));
		}
		day = Integer.toString(current.get(Calendar.DAY_OF_MONTH));

		DropDownChoice<String> yearChoice = new DropDownChoice<String>("year",
				years);
		DropDownChoice<String> monthChoice = new DropDownChoice<String>(
				"month", months);
		DropDownChoice<String> dayChoice = new DropDownChoice<String>("day",
				days);
		form.add(yearChoice);
		form.add(monthChoice);
		form.add(dayChoice);

		form.add(new Button("search") {
			public void onSubmit() {
				calc();
			}
		});

		form.add(new ListView<SalesData>("list") {
			@Override
			protected void populateItem(ListItem<SalesData> item) {
				final SalesData data = item.getModelObject();
				item.setModel(new CompoundPropertyModel<SalesData>(data));
				item.add(new Label("hour"));
				item.add(new Label("groups"));
				item.add(new Label("count"));
				item.add(new Label("totalPrice"));
				item.add(new Label("unitPrice"));
			}
		});
		calc();
	}

	private void calc() {
		list = new ArrayList<SalesData>();
		Calendar target = Calendar.getInstance();
		Calendar orderDate = Calendar.getInstance();

		target.set(Integer.parseInt(year), Integer.parseInt(month) - 1, Integer
				.parseInt(day));
		List<OrderData> orders = orderTable.findOrderByDay(target.getTime());
		for (int hour = 0; hour < 24; hour++) {
			if (hour > 0 && hour < 10) {
				continue;
			}
			SalesData sales = new SalesData();
			sales.setDay(Integer.parseInt(day));
			sales.setHour(hour);
			int groups = 0;
			int count = 0;
			int totalPrice = 0;
			for (int i = 0; i < orders.size(); i++) {
				OrderData order = orders.get(i);
				orderDate.setTime(order.getOrderDate());
				if (orderDate.get(Calendar.HOUR_OF_DAY) == hour) {
					count += order.getDetails().size();
					groups++;
					for (OrderDetail detail : order.getDetails()) {
						totalPrice += detail.getSumPrice();
					}
				}
			}
			sales.setGroups(groups);
			sales.setCount(count);
			sales.setTotalPrice(totalPrice);
			list.add(sales);
		}
	}

}
