package jp.bne.deno.ordermaid.view.admin;

import java.util.ArrayList;
import java.util.List;

import jp.bne.deno.ordermaid.dao.MenuSetTable;
import jp.bne.deno.ordermaid.model.MenuSet;
import jp.bne.deno.ordermaid.view.BasePage;

import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.CompoundPropertyModel;

import com.google.inject.Inject;

/**
 * @author hasegawt
 */
public class MenuSetPage extends BasePage {

	List<MenuSet> items = new ArrayList<MenuSet>();

	private String newMenuSetName;
	private String newSort;

	@Inject
	MenuSetTable table;

	public MenuSetPage() {

		Form<MenuSetPage> form = new Form<MenuSetPage>("form",
				new CompoundPropertyModel<MenuSetPage>(this));
		form.add(new FeedbackPanel("feedback"));

		form.add(new TextField<String>("newMenuSetName"));
		form.add(new TextField<String>("newSort"));
		items = table.findAll();

		form.add(new Button("add") {
			public void onSubmit() {
				MenuSet menuSet = new MenuSet();
				menuSet.setMenuSetName(newMenuSetName);
				menuSet.setSort(Integer.parseInt(newSort));
				try {
					table.save(menuSet);
					newMenuSetName = "";
					newSort = "";
					items = table.findAll();
				} catch (Throwable e) {
					error(e.getMessage());
				}

			}
		});
		form.add(new ListView<MenuSet>("items") {
			protected void populateItem(ListItem<MenuSet> item) {
				final MenuSet menuSet = item.getModelObject();
				item.setModel(new CompoundPropertyModel<MenuSet>(menuSet));
				item.add(new TextField<String>("menuSetName"));
				item.add(new TextField<String>("sort"));
				item.add(new Button("save") {
					public void onSubmit() {
						try {
							table.save(menuSet);
							items = table.findAll();
						} catch (Throwable e) {
							error(e.getMessage());
						}
					}
				});
			}
		});
		add(form);
	}

}
