package jp.bne.deno.ordermaid.view.helper;

import java.util.ArrayList;
import java.util.List;

import jp.bne.deno.ordermaid.dao.SystemTable;

import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;

import com.google.inject.Inject;

public class SexDropDownChoice extends DropDownChoice<String> {

	@Inject
	SystemTable table;

	public SexDropDownChoice(String id) {
		super(id);
		super.setNullValid(false);

		List<String> list = new ArrayList<String>();
		for (int i = 1; i <= 3; i++) {
			list.add(Integer.toString(i));
		}
		super.setChoices(list);
		super.setChoiceRenderer(new IChoiceRenderer<String>() {

			@Override
			public Object getDisplayValue(String arg0) {
				if (arg0.equals("1")) {
					return "男性";
				} else if (arg0.equals("2")) {
					return "女性";
				} else if (arg0.equals("3")) {
					return "その他";
				}
				return arg0;
			}

			@Override
			public String getIdValue(String arg0, int arg1) {
				return arg0;
			}
		});
	}
}
