package portablesimulator;

import portablesimulator.csv.Repository;
import portablesimulator.skillset.SkillPoint;
import portablesimulator.decoration.DecorationMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import portablesimulator.csv.PSBaseItems;
import portablesimulator.csv.PSSession;
import portablesimulator.csv.PSSearchItems;
import portablesimulator.decoration.DecorationSlot;
import portablesimulator.decoration.PlusOneFinder;
import portablesimulator.gui.PSFrame;
import portablesimulator.skillset.SkillKind;
import portablesimulator.skillset.SkillSet;

public class Engine {

    public static final String VERSION = "2.2.2";

    public Engine(PSSession session, SkillSet skills, PSSearchItems items) {
        this.session = session;
        this.skills = skills;
        this.items = items;
    }

    public PSSession session;
    public SkillSet skills;
    private PSSearchItems items;
    private PSItemList listForScanAll = new PSItemList();
    public PSItemList listForCheck = new PSItemList();
    public ArrayList<PSArmorSet> listResultSearch = new ArrayList<PSArmorSet>();
    public ArrayList<PSArmorSet> listResultChecked = new ArrayList<PSArmorSet>();
    public PlusOneFinder plusOneFinder = null;
    public boolean useAnotherCheck = false;
    public Engine superEngine = null;
    public boolean resultOnlyOne = false;

    public ArrayList<PSWrap> prepareScan(int itemType, ArrayList<PSItem> source) {
        ArrayList<PSWrap> dest = new ArrayList<PSWrap>(source.size() + 5);

        ArrayList<PSWrap> listSlot0 = new ArrayList<PSWrap>();
        ArrayList<PSWrap> listSlot1 = new ArrayList<PSWrap>();
        ArrayList<PSWrap> listSlot2 = new ArrayList<PSWrap>();
        ArrayList<PSWrap> listSlot3 = new ArrayList<PSWrap>();
        ArrayList<PSWrap> listCopie = new ArrayList<PSWrap>();

        for (PSItem item : source) {
            PSWrap wrap = new PSWrap(item);
            if (session.isExistForThisHunter(item)) {
                if (session.searchWithUsableStatus) {
                    if (items.isCandidateChecked(item) == false) {
                        continue;
                    }
                }
                if (itemType == PSItemType.TYPE_DECORATION) {
                    if (session.isExistForSkill(skills, item)) {
                        dest.add(wrap);
                    }
                } else {
                    if (item.isCopieSkill) {
                        listCopie.add(wrap);
                    } else if (session.isExistForSkill(skills, item) || session.isExistForNegativeSkill(skills, item)) {
                        dest.add(wrap);
                    } else {
                        if (item.slotCount == 0) {
                            listSlot0.add(wrap);
                        } else if (item.slotCount == 1) {
                            listSlot1.add(wrap);
                        } else if (item.slotCount == 2) {
                            listSlot2.add(wrap);
                        } else if (item.slotCount == 3) {
                            listSlot3.add(wrap);
                        }
                    }
                }
            }
        }

        if (itemType != PSItemType.TYPE_DECORATION) {
            PSWrap item;

            item = PSWrap.getVirtualWrap(itemType, PSItem.VIRTUAL_SLOT0);
            item.virtualList = listSlot0;
            //if (item.virtualList.isEmpty() == false) {
                dest.add(item);
            //}

            item = PSWrap.getVirtualWrap(itemType, PSItem.VIRTUAL_SLOT1);
            item.virtualList = listSlot1;
            if (item.virtualList.isEmpty() == false) {
                dest.add(item);
            } else if (itemType == PSItemType.TYPE_CHARM) {
                dest.add(item);
            }

            item = PSWrap.getVirtualWrap(itemType, PSItem.VIRTUAL_SLOT2);
            item.virtualList = listSlot2;
            if (item.virtualList.isEmpty() == false) {
                dest.add(item);
            } else if (itemType == PSItemType.TYPE_CHARM) {
                dest.add(item);
            }

            item = PSWrap.getVirtualWrap(itemType, PSItem.VIRTUAL_SLOT3);
            item.virtualList = listSlot3;
            if (item.virtualList.isEmpty() == false) {
                dest.add(item);
            } else if (itemType == PSItemType.TYPE_CHARM) {
                dest.add(item);
            }

            item = PSWrap.getVirtualWrap(itemType, PSItem.VIRTUAL_COPIE);
            item.virtualList = listCopie;
            if (item.virtualList.isEmpty() == false) {
                dest.add(item);
            }
        }

        return dest;
    }

    public int listToChild(int itemType, SkillSet searchSkills, ArrayList<PSWrap> listTops) {
        int proceed = 0;

       if (itemType == PSItemType.TYPE_CHARM && session.searchCharmMatome) {
            TreeSet<PSWrap> listRemove = new TreeSet<PSWrap>();
            for (int i = 0; i < listTops.size(); ++i) {
                PSWrap objI = listTops.get(i);
                TreeSet<PSWrap> child = new TreeSet<PSWrap>(objI.childArmors);
                for (int j = 0; j < listTops.size(); ++j) {
                    if (i == j) {
                        continue;
                    }
                    PSWrap objJ = listTops.get(j);
                    if (isTargetWeakChildren(objI, skills, objJ)) {
                        proceed++;
                        child.add(objJ);
                        listRemove.add(objJ);
                    }
                }
                objI.childArmors = new ArrayList<PSWrap>(child);
            }

            TreeSet<PSWrap> temp = new TreeSet<PSWrap>(listTops);
            temp.removeAll(listRemove);
            listTops.clear();
            listTops.addAll(temp);
        } else {
            for (int i = 0; i < listTops.size(); ++i) {
                PSWrap objI = listTops.get(i);
                for (int j = i + 1; j < listTops.size(); ++j) {
                    PSWrap objJ = listTops.get(j);
                    /*boolean debug = false;
                    if (objI.item.name.contains("EJ") || objJ.item.name.contains("EJ")) {
                        debug = true;
                    }*/

                    if (isTargetWeakChildren(objJ, skills, objI)) {
                        //if (debug) System.out.println("weak= " + objI + "//" + objJ);
                        proceed++;
                        objJ.childArmors.add(objI);
                        listTops.remove(i);
                        i--;
                        break;
                    } else if (isTargetWeakChildren(objI, skills, objJ)) {
                        //if (debug) System.out.println("de weak= " + objI + "//" + objJ);
                        proceed++;
                        objI.childArmors.add(objJ);
                        listTops.remove(j);
                        j--;
                        continue;
                    }
                }
            }
        }
        //System.out.println("proceed child = " + proceed);
        return proceed;
    }

    public void filterForScan(int itemType, ArrayList<PSWrap> source, ArrayList<PSWrap> listTops, List<PSWrap> listAll, DecorationMatcher matcher) {
        listAll.clear();
        listTops.clear();

/*        System.out.println("filterForScan " + source);

        PSWrap virtualNone = getVirtualItem(itemType, PSItem.VIRTUAL_NONE);
        virtualNone.maskedSkills = virtualNone.item.skills.fixColumnBy(skills);
        virtualNone.childArmors = new ArrayList<PSWrap>();
        virtualNone.sameArmors = new ArrayList<PSWrap>();
        listAll.add(virtualNone);*/

        for (PSWrap wrap : source) {
            if (!session.searchMatome
                    && wrap.item.isVirtual
                    && wrap.virtualList != null
                    && wrap.item.itemType != PSItemType.TYPE_CHARM) {
                for (PSWrap e : wrap.virtualList) {
                    e.maskedSkills = e.item.skills.fixColumnBy(skills);
                    e.childArmors = new ArrayList<PSWrap>();
                    e.sameArmors = new ArrayList<PSWrap>();
                    listAll.add(e);
                }
            } else {
                wrap.maskedSkills = wrap.item.skills.fixColumnBy(skills);
                wrap.childArmors = new ArrayList<PSWrap>();
                wrap.sameArmors = new ArrayList<PSWrap>();
                listAll.add(wrap);
            }
        }

        listTops.addAll(listAll);

        for (int i = 0; i < listTops.size(); ++i) {
            PSWrap objI = listTops.get(i);
            for (int j = i + 1; j < listTops.size(); ++j) {
                PSWrap objJ = listTops.get(j);
                if (isTargetSameSkillsAndSlot(objI, objJ)) {
                    /*System.out.println("same = " + objI + "//" + objJ);
                    if (objI.item.isVirtualNone) {
                        listTops.remove(i);
                        i--;
                        objJ.childArmors.add(objI);
                        objJ.childArmors.addAll(objI.sameArmors);
                        objI.sameArmors.clear();
                        break;
                    } else*/ {
                        listTops.remove(j);
                        j--;
                        objI.sameArmors.add(objJ);
                        objI.sameArmors.addAll(objJ.sameArmors);
                        objJ.sameArmors.clear();
                    }
                }
            }
        }

        LinkedList<ArrayList<PSWrap>> queue = new LinkedList<ArrayList<PSWrap>>();
        queue.add(listTops);

        while (queue.isEmpty() == false) {
            ArrayList<PSWrap> tops = queue.removeFirst();
            if (listToChild(itemType, skills, tops) > 0) {
                for (int i = 0; i < tops.size(); ++i) {
                    if (tops.get(i).childArmors.size() >= 2) {
                        queue.add(tops.get(i).childArmors);
                    }
                }
            }
        }
    }

    public List<PSWrap> loadExtraCharms() {
        ArrayList<PSWrap> dictionary = new ArrayList<PSWrap>();

        if (session.searchCharmCSVLevel >= 1) {
            List<PSItem> extraItem = Repository.getCharmDB().readExtraCharm(skills);
            List<PSItem> prevItem = Repository.getBaseItems().listCharm;

            for (PSItem item : extraItem) {
                PSWrap wrap = new PSWrap(item);
                wrap.maskedSkills = item.skills.fixColumnBy(skills);
                dictionary.add(wrap);
            }
        }

        return dictionary;
    }

    public ArrayList<PSWrap> getVirtualCharmList(List<PSWrap> listCharms, PSWrap none) {
        TreeMap<SkillSet, PSWrap> compact0 = new TreeMap<SkillSet, PSWrap>();
        TreeMap<SkillSet, PSWrap> compact1 = new TreeMap<SkillSet, PSWrap>();
        TreeMap<SkillSet, PSWrap> compact2 = new TreeMap<SkillSet, PSWrap>();
        TreeMap<SkillSet, PSWrap> compact3 = new TreeMap<SkillSet, PSWrap>();

        none.charmGroup = new ArrayList<PSWrap>();
        none.charmGroupSeek = new ArrayList<PSWrap>();
        for (PSWrap item : listCharms) {
            SkillSet masked = item.item.skills.fixColumnBy(skills);

            TreeMap<SkillSet, PSWrap> map = null;
            switch (item.item.slotCount) {
                case 0:
                    map = compact0;
                    break;
                case 1:
                    map = compact1;
                    break;
                case 2:
                    map = compact2;
                    break;
                case 3:
                    map = compact3;
                    break;
            }
            PSWrap virtual = map.get(masked);
            if (virtual == null) {
                PSItem v;
                if (masked.isZero()) {
                    v = PSItem.getVirtualItem(PSItemType.TYPE_CHARM, item.item.slotCount);
                }else {
                    v = new PSItem(PSItemType.TYPE_CHARM, "");
                }
                v.isVirtual = true;
                v.slotCount = item.item.slotCount;
                v.skills = masked;
                virtual = new PSWrap(v);
                virtual.maskedSkills = masked;
                map.put(masked, virtual);
                if (virtual.charmGroup == null) {
                    virtual.charmGroup = new ArrayList<PSWrap>();
                    virtual.charmGroupSeek = new ArrayList<PSWrap>();
                }
            }
            none.charmGroup.add(item);
            none.charmGroupSeek.add(virtual);
            virtual.charmGroup.add(item);
            virtual.charmGroupSeek.add(virtual);
        }

        ArrayList<PSWrap> ret = new ArrayList<PSWrap>();

        for (PSWrap wrap : compact0.values()) {
            ret.add(wrap);
        }
        for (PSWrap wrap : compact1.values()) {
            ret.add(wrap);
        }
        for (PSWrap wrap : compact2.values()) {
            ret.add(wrap);
        }
        for (PSWrap wrap : compact3.values()) {
            ret.add(wrap);
        }

        for (int i = 0; i < ret.size(); ++i) {
            PSWrap objI = ret.get(i);
            for (int j = 0; j < ret.size(); ++j) {
                if (i == j) {
                    continue;
                }
                PSWrap objJ = ret.get(j);

                if (isTargetWeakChildren(objI, skills, objJ)) {
                    objJ.charmGroup.addAll(objI.charmGroup);
                    objJ.charmGroupSeek.addAll(objI.charmGroupSeek);
                }
            }
        }

        return ret;
    }

    public boolean pageActionScan(PSFrame frame, IProgress progress) {
        PSItemList listForScanTop = new PSItemList();

        HashSet<PSArmorSet> prevResult = null;
        if (superEngine != null && superEngine.listResultSearch != null && superEngine.listResultSearch.size() > 0) {
            prevResult = new HashSet<PSArmorSet>();
            prevResult.addAll(superEngine.listResultSearch);
        }
        listForScanAll = new PSItemList();
        listForCheck = new PSItemList();

        PSBaseItems dataItems = Repository.getBaseItems();
        PSItemList listForCandidate = new PSItemList();
        listForCandidate.listEquipHead = prepareScan(PSItemType.TYPE_HEAD, dataItems.listEquipHead);
        listForCandidate.listEquipBody = prepareScan(PSItemType.TYPE_BODY, dataItems.listEquipBody);
        listForCandidate.listEquipArm = prepareScan(PSItemType.TYPE_ARM, dataItems.listEquipArm);
        listForCandidate.listEquipWeist = prepareScan(PSItemType.TYPE_WEIST, dataItems.listEquipWeist);
        listForCandidate.listEquipLeg = prepareScan(PSItemType.TYPE_LEG, dataItems.listEquipLeg);
        if (Repository.getResource().existCharm()) {
            listForCandidate.listCharm = prepareScan(PSItemType.TYPE_CHARM, dataItems.listCharm);
            listForCandidate.listCharm.addAll(loadExtraCharms());
            viewCountTouch.clear();
            if (session.searchCharmMatome) {
                listForCandidate.listCharm = getVirtualCharmList(listForCandidate.listCharm, PSWrap.getVirtualWrap(PSItemType.TYPE_CHARM, PSItem.VIRTUAL_NONE));
                viewCountTouch.addAll(listForCandidate.listCharm);
            }
        } else {
            listForCandidate.listCharm = new ArrayList<PSWrap>();
        }
        listForCandidate.listDecoration = prepareScan(PSItemType.TYPE_DECORATION, dataItems.listDecoration);

        Collection<PSArmorSet> listArmorSet = null;
        
        if (session.searchOrderByDeffence) {
            listArmorSet = new TreeSet<PSArmorSet>();
        }else {
            listArmorSet = new ArrayList<PSArmorSet>();
        }

        listForScanTop.listDecoration = listForCandidate.listDecoration;
        listForScanAll.listDecoration = listForCandidate.listDecoration;

        DecorationMatcher matcher = new DecorationMatcher(session, skills, items);

        filterForScan(PSItemType.TYPE_HEAD, listForCandidate.listEquipHead, listForScanTop.listEquipHead, listForScanAll.listEquipHead, matcher);
        filterForScan(PSItemType.TYPE_BODY, listForCandidate.listEquipBody, listForScanTop.listEquipBody, listForScanAll.listEquipBody, matcher);
        filterForScan(PSItemType.TYPE_ARM, listForCandidate.listEquipArm, listForScanTop.listEquipArm, listForScanAll.listEquipArm, matcher);
        filterForScan(PSItemType.TYPE_WEIST, listForCandidate.listEquipWeist, listForScanTop.listEquipWeist, listForScanAll.listEquipWeist, matcher);
        filterForScan(PSItemType.TYPE_LEG, listForCandidate.listEquipLeg, listForScanTop.listEquipLeg, listForScanAll.listEquipLeg, matcher);
        filterForScan(PSItemType.TYPE_CHARM, listForCandidate.listCharm, listForScanTop.listCharm, listForScanAll.listCharm, matcher);

        long cntor = 0;
        long lastTick = 0;
        boolean disp = true;
        ArrayList<PSArmorSet> childQue = new ArrayList<PSArmorSet>();
        TreeSet<PSArmorSet> childAlready = new TreeSet<PSArmorSet>();
        long childAlreadyPurgeCount = 0;

        long finderCancel = 0;

        plusOneFinder = new PlusOneFinder(session, skills, items);
        plusOneFinder.useNestedFind = false;
        plusOneFinder.onlySkillScan = true;

        ArrayList<PSArmorSet> setList = new ArrayList<PSArmorSet>();
        ArrayList<DecorationSlot> tempResult = new ArrayList<DecorationSlot>();

        MatrixBuilder topMatrix = new MatrixBuilder();
        topMatrix.addColumn(listForScanTop.listEquipHead);
        topMatrix.addColumn(listForScanTop.listEquipBody);
        topMatrix.addColumn(listForScanTop.listEquipArm);
        topMatrix.addColumn(listForScanTop.listEquipWeist);
        topMatrix.addColumn(listForScanTop.listEquipLeg);
        if (Repository.getResource().existCharm()) { 
            topMatrix.addColumn(listForScanTop.listCharm);
        }
        topMatrix.start();
        long cntorMax = topMatrix.iteratorCount();

        progress.startProgress();

        while (!childQue.isEmpty() || topMatrix.hasNext()) {
            if (progress.isCanceled()) {
                break;
            }
            if (disp || (cntor & 0x3ff) == 0) {
                long curTick = System.currentTimeMillis();
                if (curTick - lastTick >= 500) {
                    double percent = (double) cntor * 100.0 / cntorMax;
                    progress.progress(percent);
                    progress.println(
                            "Hit: " + listArmorSet.size() + "\n"
                            + "Count: " + cntor + "/" + cntorMax + "\n"
                            + "Percent: " + percent + "%" + "\n"
                            + (session.searchPlusOneFast ? ("+1: " + plusOneFinder.getResultAsText(null, false) + "\n") : ""));
                    lastTick = curTick;
                }
                disp = false;
            }
            cntor++;

            PSArmorSet armorSet = null;

            boolean fromQueue = false;
            if (!childQue.isEmpty()) {
                armorSet = childQue.remove(childQue.size() - 1);
                fromQueue = true;
            } else {
                armorSet = new PSArmorSet();
                topMatrix.next(armorSet.listItems);
                armorSet.targetSkills = skills;
                armorSet.calculateUseList(null, true);
            }
/*            if (armorSet.listItems.get(0).item.name.contains("VhEAC")
             //&& armorSet.listItems.get(1).item.name.contains("EJ")
             //&& armorSet.listItems.get(2).item.name.contains("Vo[")
             //&& armorSet.listItems.get(3).item.name.contains("EJ")
             //&& armorSet.listItems.get(4).item.name.contains("EJ")
                    ) {
                System.out.println(armorSet);
            }*/
            if (prevResult != null) {
                if (prevResult.contains(armorSet) == false) {
                    continue;
                }
            }
            armorSet.weaponSlotCount = session.searchWeaponSlotCount;
            if (fromQueue) {
                if (childAlreadyPurgeCount > 0) {
                    if (listArmorSet.contains(armorSet)) {
                        continue;
                    }
                }
            }

            matcher.useAnotherCheck = useAnotherCheck;
            if (useAnotherCheck) {
                tempResult.clear();
                if (matcher.canHaveEnoughDecoration(armorSet, true, tempResult) == false) {
                    continue;
                }
            } else if (session.searchPlusOneFast) {
                tempResult.clear();
                if (matcher.canHaveEnoughDecoration(armorSet, true, tempResult) == false) {
                    continue;
                }
            } else if(armorSet.weaponSlotCount <= 0) {
                if (matcher.canHaveEnoughDecoration(armorSet, false, null) == false) {
                    continue;
                }
            } else {
                tempResult.clear();
                if (matcher.canHaveEnoughDecoration(armorSet, true, tempResult) == false) {
                    continue;
                }
                int realWeaponSlotCount = matcher.fixRealWeaponSlot(armorSet, tempResult);
                if (realWeaponSlotCount != armorSet.weaponSlotCount) {
                    armorSet.weaponSlotCount = realWeaponSlotCount;
                }
            }

            if (!session.searchPlusOneFast && session.searchMatome) {
                boolean haveSkip = false;
                int max;
                if (Repository.getResource().existCharm()) {
                    max = PSItemType.TYPE_CHARM;
                }else {
                    max = PSItemType.TYPE_LEG;
                }
                for (int type = PSItemType.TYPE_HEAD; type <= max; type ++) {
                    PSItem item = armorSet.listItems.get(type).item;
                    if (item.slotCount == 0 && item.isCopieSkill == false && item.skills.isZero()) {
                        continue;
                    }
                    if (item.slotCount > 0 && item.isVirtual) {
                        PSArmorSet newSet2 = armorSet.makeSetCopy();
                        newSet2.listItems.set(type, PSWrap.getVirtualWrap(type, item.slotCount - 1));
                        //newSet2.calculateUseList(null, false);
                        if (matcher.canHaveEnoughDecoration(newSet2, false, null)) {
                            if (childAlready.contains(newSet2)) {
                                haveSkip = true;
                                continue;
                            }
                            childQue.add(newSet2);
                            childAlready.add(newSet2);
                            cntorMax ++;
                            haveSkip = true;
                        }
                        continue;
                    }

                    PSArmorSet newSet = armorSet.makeSetCopy();
                    newSet.listItems.set(type, PSWrap.getVirtualWrap(type, 0));
                    //newSet.calculateUseList(null, false);

                    if (matcher.canHaveEnoughDecoration(newSet, false, null)) {
                        if (childAlready.contains(newSet)) {
                            haveSkip = true;
                            continue;
                        }
                        childQue.add(newSet);
                        childAlready.add(newSet);
                        cntorMax ++;
                        haveSkip = true;
                    }
                }
                if (haveSkip) {
                    continue;
                }
            }
            if (Repository.getResource().existCharm()) {
                if (!session.searchPlusOneFast && session.searchMatome) {
                    if (isCharmHaveReplaceMent(matcher, armorSet)) {
                        cntorMax += armorSet.createChildSet(false, childAlready, childQue);
                        if (childAlready.size() >= 30000) {
                            childAlready = new TreeSet<PSArmorSet>(childQue);
                            childAlreadyPurgeCount++;
                        }
                        continue;
                    }
                }
            }
            armorSet.session = session;

            setList.clear();
            armorSet.drawArmorSets(setList, session.searchMatome, session.searchCharmMatome);
            disp = true;

            cntorMax += setList.size();

            for (PSArmorSet set : setList) {
                if (progress.isCanceled()) {
                    break;
                }
                if (disp || (cntor & 0x3ff) == 0) {
                    long curTick = System.currentTimeMillis();
                    if (curTick - lastTick >= 500) {
                        double percent = (double) cntor * 100.0 / cntorMax;
                        progress.progress(percent);
                        progress.println(
                                "Hit: " + listArmorSet.size() + "/ cancel " + finderCancel + "\n"
                                + "Count: " + cntor + "/" + cntorMax + "\n"
                                + "Percent: " + percent + "%" + "\n"
                                + (session.searchPlusOneFast ? ("+1: " + plusOneFinder.getResultAsText(null, false) + "\n") : ""));
                        lastTick = curTick;
                    }
                    disp = false;
                }
                cntor++;

                if (session.searchPlusOneFast) {
                    if (!plusOneFinder.findAnyPlusOne(set, null, 60000, tempResult, null)) {
                        finderCancel++;
                        continue;
                    }
                    if (plusOneFinder.onlySkillScan) {
                        finderCancel++;
                        continue;
                    }
                }

                listArmorSet.add(set);
                if (listArmorSet.size() >= session.searchMaxCount) {
                    if (!session.searchOrderByDeffence) {
                        //System.out.println("BREAK");
                        break;
                    }
                }
            }
            if (resultOnlyOne) {
                return true;
            }
            disp = true;
            if (listArmorSet.size() >= session.searchMaxCount) {
                if (session.searchOrderByDeffence) {
                    while (listArmorSet.size() > session.searchMaxCount) {
                        ((TreeSet)listArmorSet).pollLast();
                    }
                } else if (session.searchPlusOneFast) {
                    listArmorSet.clear();
                    plusOneFinder.trashGarbage();
                } else {
                    //System.out.println("BREAK");
                    break;
                }
            }
            cntorMax += armorSet.createChildSet(false, childAlready, childQue);
            if (childAlready.size() >= 30000) {
                childAlready = new TreeSet<PSArmorSet>(childQue);
                childAlreadyPurgeCount++;
            }
        }

        listResultSearch.addAll(listArmorSet);
        progress.println(
                  "Hit: " + listArmorSet.size() + "/ cancel " + finderCancel + "\n"
                + "Count: " + cntor + "/" + cntorMax + "\n"
                + "Percent: 100%" + "\n"
                + (session.searchPlusOneFast ? ("+1: " + plusOneFinder.getResultAsText(null, false) + "\n") : ""));
        if (session.searchPlusOneFast) {
            Map<SkillSet, Set<PSArmorSet>> mapPlusOne = plusOneFinder.getResultMap(null);
            ButtonGroup buttonGroup = new ButtonGroup();
            for(SkillSet skills : mapPlusOne.keySet()) {
                //Set<PSArmorSet> set = mapPlusOne.get(skills);
                //frame.addSkillButtonToPlusOne(buttonGroup, skills, set.size(), set.iterator().next().toString());
                frame.addSkillButtonToPlusOne(buttonGroup, skills, 1, "");
            }
        }
        if (session.searchPlusOneFast) {
            if (plusOneFinder.onlySkillScan) {
                plusOneFinder = null;
            }
        }
        return listResultSearch.size() > 0 ? true : false;
    }

    public ArrayList<PSWrap> filterByViewFound(List<PSWrap> armors) {
        ArrayList<PSWrap> result = new ArrayList<PSWrap>(armors.size() + 5);

        for (PSWrap armor : armors) {
            if (armor.item.viewFound) {
                result.add(armor);
            }
        }

        Collections.<PSWrap>sort(result);

        return result;
    }

    public void pagePrepareCheck() {
        for (PSArmorSet myset : listResultSearch) {
            for (PSWrap wrap : myset.listItems) {
                if (wrap.item.itemType == PSItemType.TYPE_CHARM) {
                    //System.out.println("---- " + wrap);
                }
                wrap.item.viewFound = true;
                wrap.item.viewCount++;
            }
        }

        listResultChecked.clear();
        listResultChecked.addAll(listResultSearch);

        listForCheck = new PSItemList();
        listForCheck.listEquipHead = filterByViewFound(listForScanAll.listEquipHead);
        listForCheck.listEquipBody = filterByViewFound(listForScanAll.listEquipBody);
        listForCheck.listEquipArm = filterByViewFound(listForScanAll.listEquipArm);
        listForCheck.listEquipWeist = filterByViewFound(listForScanAll.listEquipWeist);
        listForCheck.listEquipLeg = filterByViewFound(listForScanAll.listEquipLeg);
        listForCheck.listCharm = filterByViewFound(listForScanAll.listCharm);

        listForCheck.listDecoration = null;
    }

    ArrayList<PSWrap> viewCountTouch = new ArrayList<PSWrap>();

    public void clearViewCount(boolean doClearFoundFlag) {
        PSBaseItems items = Repository.getBaseItems();
        ArrayList<PSItem>[] listList = new ArrayList[]{
            items.listEquipHead,
            items.listEquipBody,
            items.listEquipArm,
            items.listEquipWeist,
            items.listEquipLeg,
            items.listDecoration,
            items.listCharm,};

        for (ArrayList<PSItem> list : listList) {
            for (PSItem item : list) {
                item.viewCount = 0;
                if (doClearFoundFlag) {
                    item.viewFound = false;
                }
            }
        }

        for (int type = PSItemType.TYPE_HEAD; type <= PSItemType.TYPE_CHARM; ++ type) {
            for (int slot = -1; slot <= 3; ++ slot) {
                PSWrap wrap = PSWrap.getVirtualWrap(type, slot);
                wrap.item.viewCount = 0;
                if (doClearFoundFlag) {
                    wrap.item.viewFound = false;
                }
            }
        }

        for (PSWrap wrap : viewCountTouch) {
            wrap.item.viewCount = 0;
            if (doClearFoundFlag) {
                wrap.item.viewFound = false;
            }
        }

    }

    public void findPlusOne(final PSFrame frame, final IProgress progress) {
        final List<PSArmorSet> setList = this.listResultChecked;

        if (plusOneFinder == null || plusOneFinder.useNestedFind == true) {
            plusOneFinder = new PlusOneFinder(session, skills, items);
            plusOneFinder.useNestedFind = false;
            plusOneFinder.onlySkillScan = true;
        }

        Thread thread = new Thread() {

            public void run() {
                try {
                    progress.startProgress();

                    long count = 0;
                    List<SkillPoint> pointList = Repository.getSkillCategories().listPoints();
                    long maxCount = setList.size();
                    int armorCount = 0;
                    long prevTick = 0;
                    for (PSArmorSet set : setList) {
                        if (progress.isCanceled()) {
                            break;
                        }
                        long tick = System.currentTimeMillis();
                        if (tick - prevTick >= 500) {
                            StringBuilder str = new StringBuilder();
                            String text = plusOneFinder.getResultAsText(setList, false);
                            str.append("\nSearching " + count);
                            str.append("\n" + text);
                            progress.println(str.toString());
                            progress.progress(count * 100.0 / maxCount);
                            prevTick = tick;
                        }
                        count++;
                        plusOneFinder.findAnyPlusOne(set, null, 60000, null, null);
                    }
                    if (true) {
                        StringBuilder str = new StringBuilder();
                        String text = plusOneFinder.getResultAsText(setList, false);
                        str.append("\nSearching " + count);
                        str.append("\n" + text);
                        progress.println(str.toString());
                        progress.progress(count * 100.0 / maxCount);
                    }
                    plusOneFinder.tryFixMinus(setList, null);
                    {
                        StringBuilder str = new StringBuilder();
                        String text = plusOneFinder.getResultAsText(setList, false);
                        str.append("\nSearching " + count);
                        str.append("\n" + text);
                        progress.println(str.toString());
                        progress.progress(count * 100.0 / maxCount);
                    }
                } catch (Throwable e) {
                    e.printStackTrace();
                } finally {
                    progress.finishProgress();

                    Map<SkillSet, Set<PSArmorSet>> mapPlusOne = plusOneFinder.getResultMap(null);
                    ButtonGroup buttonGroup = new ButtonGroup();
                    for(SkillSet skills : mapPlusOne.keySet()) {
                        Set<PSArmorSet> set = mapPlusOne.get(skills);
                        frame.addSkillButtonToPlusOne(buttonGroup, skills, set.size(), "");
                    }
                }
            }
        };

        thread.start();
    }

    public static boolean isTargetSameSkillsAndSlot(PSWrap base, PSWrap target) {
        if (base.item.isCopieSkill) {
            if (target.item.isCopieSkill) {
                return true;
            }
            return false;
        } else if (target.item.isCopieSkill) {
            return false;
        }
        if (base.item.slotCount != target.item.slotCount) {
            return false;
        }
        if (base.maskedSkills.equals(target.maskedSkills) == false) {
            return false;
        }
        return true;
    }

    public static boolean isTargetWeakChildren(PSWrap base, SkillSet searchSkills, PSWrap grp) {
        if (base.item.isCopieSkill || grp.item.isCopieSkill) {
            return false;
        }
        if (base.item.slotCount < grp.item.slotCount) {
            return false;
        }
        if (isTargetSameSkillsAndSlot(base, grp)) {
            return false;
        }

        SkillSet skill1 = base.maskedSkills;
        SkillSet skill2 = grp.maskedSkills;

        for (int i = 0; i < searchSkills.size(); ++i) {
            final SkillKind kind = searchSkills.kind(i);
            int x1 = skill1.indexOfKind(kind);
            int x2 = skill2.indexOfKind(kind);
            if (x1 < 0 && x2 < 0) {
                continue;
            }
            if (x1 < 0) {
                return false;
            }
            if (x2 < 0) {
                continue;
            }
            if (searchSkills.positive(i)) {
                if (skill1.point(x1) < skill2.point(x2)) {
                    return false;
                }
            } else {
                if (skill1.point(x1) > skill2.point(x2)) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isCharmHaveReplaceMent(DecorationMatcher matcher, PSArmorSet set) {
        boolean found = false;
        int type = PSItemType.TYPE_CHARM;
        PSWrap noneItem = PSWrap.getVirtualWrap(type, 0);
        PSWrap original = set.listItems.get(type);
        if (original == null) {
            return false;
        }
        if (original.item.slotCount == 0 && original.item.isVirtual) {
            return false;
        }
        set.listItems.set(type, noneItem);
        if (matcher.canHaveEnoughDecoration(set, false, null)) {
            found = true;
        }
        if (type == PSItemType.TYPE_CHARM) {
            for (PSWrap replace : original.childArmors) {
                if (replace.item == original.item) {
                    continue;
                }

                set.listItems.set(PSItemType.TYPE_CHARM, replace);
                if (matcher.canHaveEnoughDecoration(set, false, null)) {
                    found = true;
                }
            }
        }

        set.listItems.set(type, original);
        set.calculateUseList(null, true);
        return found;
    }
}
