package portablesimulator.csv;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class CSVWriter {
    BufferedWriter output;

    public CSVWriter(String path) throws IOException {
        output = new BufferedWriter(new FileWriter(path));
    }

    public void writeLine(List<String> line) throws IOException {
        boolean first = true;
        for(String element : line) {
            if (!first) {
                output.write(',');
            }
            if (element.indexOf(',') >= 0) {
                output.write('"');
                output.write(element);
                output.write('"');
            }else {
                output.write(element);
            }
            first = false;
        }
        output.write("\r\n");
    }

    public void close() throws IOException {
        output.close();
    }
}
