package portablesimulator.decoration;

import java.util.ArrayList;
import java.util.List;
import portablesimulator.PSItem;

public class DecorationCount implements Comparable {

    private List<PSItem> deco;
    private boolean decoIsRef;
    private int[] count;

    public int size() {
        return deco.size();
    }

    public PSItem deco(int x) {
        return deco.get(x);
    }

    public int count(int x) {
        return count[x];
    }

    public DecorationCount(List<PSItem> decorations) {
        this.deco = decorations;
        this.count = new int[decorations.size()];
        this.decoIsRef = true;
    }

    public DecorationCount makeCopy() {
        DecorationCount obj = new DecorationCount(deco);
        for(int i = 0; i < count.length; ++ i) {
            obj.count[i] = count[i];
        }
        return obj;
    }

    public void ensure(int ensize) {
        if (ensize < 20) {
            ensize = 20;
        }
        if (count == null || count.length < ensize) {
            int[] newCount = new int[ensize];
            if (count != null) {
                for (int i = 0; i < count.length; ++i) {
                    newCount[i] = count[i];
                }
            }
            count = newCount;
        }
    }

    public void increment(PSItem e) {
        for (int i = 0; i < deco.size(); ++i) {
            if (deco.get(i) == e) {
                count[i] ++;
                return;
            }
        }
        if (decoIsRef) {
            decoIsRef = false;
            deco = new ArrayList<PSItem>(deco);
        }
        deco.add(e);
        ensure(deco.size());
        count[deco.size() - 1] = 1;
    }

    public void set(PSItem e, int x) {
        for (int i = 0; i < deco.size(); ++i) {
            if (deco.get(i) == e) {
                count[i] = x;
                return;
            }
        }
        if (decoIsRef) {
            decoIsRef = false;
            deco = new ArrayList<PSItem>(deco);
        }
        deco.add(e);
        ensure(deco.size());
        count[deco.size() - 1] = x;
    }

    public void putAll(DecorationCount set) {
        ensure(set.deco.size());
        this.deco = set.deco;
        this.decoIsRef = true;
        for (int i = 0; i < set.deco.size(); ++i) {
            count[i] = set.count[i];
        }
    }

    public void addAll(DecorationCount set) {
        for(int i = 0; i < set.deco.size(); ++ i) {
            PSItem e = set.deco.get(i);
            int n = set.count[i];

            boolean found = false;
            for (int x = 0; x < deco.size(); ++ x) {
                if (deco.get(x) == e) {
                    count[x] += n;
                    found = true;
                    break;
                }
            }
            if (!found) {
                if (decoIsRef) {
                    decoIsRef = false;
                    deco = new ArrayList<PSItem>(deco);
                }
                deco.add(e);
                ensure(deco.size());
                count[deco.size() - 1] = n;
            }
        }
    }

    public void minusAll(DecorationCount set) {
        for(int i = 0; i < set.deco.size(); ++ i) {
            PSItem e = set.deco.get(i);
            int n = set.count[i];

            boolean found = false;
            for (int x = 0; x < deco.size(); ++ x) {
                if (deco.get(x) == e) {
                    count[x] -= n;
                    found = true;
                    break;
                }
            }
            if (!found) {
                if (decoIsRef) {
                    decoIsRef = false;
                    deco = new ArrayList<PSItem>(deco);
                }
                deco.add(e);
                ensure(deco.size());
                count[deco.size() - 1] = -n;
            }
        }
    }

    public void clear() {
        for (int i = 0; i < count.length; ++i) {
            count[i] = 0;
        }
    }

    public boolean isEmpty() {
        for (int i = 0; i < deco.size(); ++ i) {
            if (count[i] != 0) {
                return false;
            }
        }
        return true;
    }

    public Integer get(PSItem e) {
        for (int i = 0; i < deco.size(); ++i) {
            if (deco.get(i) == e) {
                return count[i];
            }
        }
        return null;
    }


    public int compareTo(Object t) {
        DecorationCount target = (DecorationCount)t;

        if (target.deco == this.deco) {
            for (int i = 0; i < deco.size(); ++ i) {
                int x = count[i] - target.count[i];
                if (x < 0) return -1;
                if (x > 0) return  1;
            }
            return 0;
        }

        DecorationCount compareItem = new DecorationCount(new ArrayList<PSItem>());
        compareItem.addAll(this);
        compareItem.minusAll(target);

        for (int i = 0; i < compareItem.deco.size(); ++ i) {
            if (compareItem.count[i] < 0) return -1;
            if (compareItem.count[i] > 0) return  1;
        }

        return 0;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < deco.size(); ++ i) {
            str.append(deco.get(i).name);
            str.append("=");
            str.append(count[i]);

            if (i != deco.size() - 1) {
                str.append(",");
            }
        }
        return str.toString();
    }
}
