package portablesimulator.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import portablesimulator.skillset.SkillPoint;

public class MyCheckBoxForSkillPoint extends JCheckBoxEx {
    public final SkillPoint skillPoint;
    public final PSFrame frame;

    public MyCheckBoxForSkillPoint(final PSFrame frame, final SkillPoint skillPoint, final boolean selected) {
        super();
        this.frame = frame;
        this.skillPoint = skillPoint;
        this.setText(skillPoint.pointName);
        this.setSelected(true);

        addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                frame.onMySkillPointCheck(skillPoint);
            }
        });
    }

    @Override
    public void setSelected(boolean sel) {
        super.setSelected(sel);
    }
}
