package portablesimulator.gui;

import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import portablesimulator.PSArmorSet;

public class MyListCellArmorSetText extends DefaultListCellRenderer {

    public Font font = null;
    public List<Integer> widthList = null;
    public Map<String, Integer> cache = new HashMap<String, Integer>();

    public int stringWidth(String text) {
        if (text.length() <=3 || text.startsWith("[")) {
            return text.getBytes().length;
        }else {
            Integer x = cache.get(text);
            if (x == null) {
                x = text.getBytes().length;
                cache.put(text, x);
            }
            return x;
        }
    }

    public List<Integer> calculateWidth(JList list) {
        if (widthList == null) {
            widthList = new ArrayList<Integer>();
            if (list.getModel().getSize() > 0) {
                List<String> line = new ArrayList<String>();
                for (int i = 0; i < list.getModel().getSize(); ++i) {
                    PSArmorSet set = (PSArmorSet)list.getModel().getElementAt(i);
                    line.clear();
                    formatArmor(set, line);
                    while (widthList.size() < line.size()) {
                        widthList.add(0);
                    }
                    for (int x = 0; x < line.size(); ++ x) {
                        String v = line.get(x);
                        Integer prev = widthList.get(x);
                        int width = stringWidth(v);
                        if (prev < width) {
                            widthList.set(x, width);
                        }
                    }
                }
            }
        }
        return widthList;
    }

    public void formatArmor(PSArmorSet set, List<String> line) {
        line.add(String.valueOf(set.defMax));
        line.add("[" + set.weaponSlotCount + "]");
        for (int x = 0; x < set.listItems.size(); ++x) {
            line.add(set.listItems.get(x).item.name);
        }
        line.add(set.getShellValuesAsText());
    }

    public void fitArmorLine(JList list, List<String> line) {
        List<Integer> widthList = calculateWidth(list);
        for(int x = 0; x < line.size(); ++ x) {
            String v = line.get(x);
            Integer fit = widthList.get(x);
            int width = stringWidth(v);
            if (width < fit) {
                int step = fit - width;
                StringBuilder str = new StringBuilder(v);
                for (int n = 0; n < step; ++ n) {
                    str.append(" ");
                }
                line.set(x, str.toString());
            }
        }
    }

    public Component getListCellRendererComponent(JList jlist, Object o, int i, boolean bln, boolean bln1) {
        PSArmorSet set = (PSArmorSet) o;
        if (font == null) {
            font = new Font(Font.MONOSPACED, Font.PLAIN, 12);
        }
        String value = "";
        if (set != null) {
            List<String> line = new ArrayList<String>();
            formatArmor(set, line);
            fitArmorLine(jlist, line);

            StringBuilder str = new StringBuilder();
            for (int x = 0; x < line.size(); ++x) {
                if (x != 0) {
                    str.append(",");
                }
                str.append(line.get(x));
            }
            value = str.toString();
        }
        this.setFont(font);
        super.getListCellRendererComponent(jlist, value, i, bln, bln1);
        this.setFont(font);
        return this;
    }
}
