# PacBang Start Manual
## Original document by Carl Duff
## Updated by linux-aarhus

## 1. Update System
-------------------
The FIRST thing to do is to update your system ("$" is the prompt)

    $ sudo pacman -Syyu

If there is an error when updating, check your internet connection. Otherwise, try refreshing
the package keys (used to verify that packages are official) before trying again

    $ sudo pacman-key --init
    $ sudo pacman-key --populate archlinux
    $ sudo pacman-key --refresh-keys

## 2. If no Sound
-----------------
ALSA mutes the main sound channel by default:

- Right click volume icon, "Open Mixer"
- First two "Master" channels should have "00" at the bottom.
- If either is "MM" (mute), use the left/right arrow keys to highlight channel name and press "m"
- Use up/down arrow keys to set base volume
- Close window, use mouse scroll to set volume

If this does not work, it is also possible that the wrong default sound device has been selected:

- Right click the volume icon, select "preferences"
- Select "Channels" tab
- Select a different / the other device.

## 3. Pulse Audio
-----------------
To install PulseAudio

    $ sudo pacman -Syu pulseaudio

## 4. GUI Sound Mixer
---------------------
gnome-alsamixer is recommended if you want to replace alsamixer for ALSA.
pavucontrol is recommended for PulseAudio.

    $ pacman -Syu gnome-alsamixer
    
Or

    $ pacman -Syu pavucontrol

- Right click volume icon, "Preferences"
- Click "status icon"
- Replace "lxterminal -e alsamixer" with "gnome-alsamixer" or "pavucontrol"
- Close window.


5. AUR (Arch User Repository)
------------------------------------
- First ensure the necessary packages has been installed ("$" is the prompt)

    $ sudo pacman -Syu base-devel pacman-contrib git --needed

Browse [https://aur.archlinux.org/packages](https://aur.archlinux.org/packages) to find your package

Clone the package desired package using git

    $ git clone https://aur.archlinux.org/package-name.git

Cd to the package folder

    $ cd package-name

Install dependencies, build the package and install it

    $ makepkg -is

If you would like a clean system you can add the following arguments to makepkg

    $ makepkg -isrc


6. Gstreamer Codecs
-------------------
Required codecs should be installed as dependencies of desired multimedia player(s) (e.g. vlc).
They can be installed explicitly with the command ("$" is the prompt)

    $ sudo pacman -Syu gstreamer gstreamer-plugins-base gstreamer-plugins-good gstreamer-plugings-bad gstreamer-plugins-ugly
