﻿using System;
using System.Collections.Generic;
using Progressive.PecaStarter.Util;

namespace Progressive.PecaStarter.Entity
{
    [Serializable]
    public class SaveData
    {
        public double Left;
        public double Top;
        public double Height;
        public double Width;
        // public List<string> VisitedSites;
        // public uint YellowPagesSelectedIndex;
        // public List<string> YellowPagesPrefixes;
        public string SelectedYellowPagesName;
        public List<YellowPages> YellowPagesValues;
        //public List<string> ExternalSourceUrls;
        public string ExternalSourceStreamUrl;
        public List<string> ExternalSourceNames;
        public List<string> ExternalSourceGenres;
        public List<string> ExternalSourceDescriptions;
        public List<string> ExternalSourceContacts;
        public List<string> ExternalSourceComments;
        //public string ExternalSourceType;
        //public List<string> CurrentTrackArtists;
        //public List<string> CurrentTrackTitles;
        //public List<string> CurrentTrackAlbums;
        //public List<string> CurrentTrackGenres;
        //public List<string> CurrentTrackContacts;
        //public string SettingsServerAddress;
        public uint SettingsPort;
        public bool SettingsIsNotifyIcon;
        public bool SettingsIsSavePosition;
        public bool SettingsLogging;
        public string SettingsLogPath;
        public uint SettingsDelay;

        public SaveData()
        {
            SettingsPort = 7144;
        }
    }

    public class YellowPages
    {
        public string Name;
        public List<Parameter> Parameters;
    }

    public class Parameter
    {
        public string Key;
        public string Value;

        public static Parameter Create(string key, string value)
        {
            return new Parameter() { Key = key, Value = value };
        }
    }
}
