﻿using System;
using System.Collections.Generic;
using System.Xml.Linq;
using System.Threading.Tasks;
using System.Net;

namespace Progressive.PecaStarter.Model
{
    public abstract class YellowPages
    {
        protected XDocument Xml { get; private set; }

        public string Name
        {
            get { return Xml.Element("yellowpages").Element("name").Value; }
        }
        public string NoticeUrl
        {
            get { return Xml.Element("yellowpages").Element("notice").Value; }
        }
        public virtual IList<string> Components
        {
            get
            {
                if (Xml.Element("yellowpages").Element("components") == null)
                {
                    return new List<string>();
                }
                throw new NotImplementedException();
            }
        }

        public static YellowPages GetInstance(string path)
        {
            var xml = XDocument.Load(path);
            var list = xml.Elements();
            if (xml.Element("yellowpages").Element("peercast") != null)
            {
                return new PeercastYellowPages(xml);
            }
            if (xml.Element("yellowpages").Element("webapi") != null)
            {
                return new WebApiYellowPages(xml);
            }
            throw new ArgumentException();
        }

        public YellowPages(string text)
        {
            Xml = XDocument.Parse(text);
        }
        public YellowPages(XDocument xml)
        {
            Xml = xml;
        }

        public bool CanGetNoticeHash()
        {
            var check = Xml.Element("yellowpages").Element("notice").Attribute("check");
            if (check == null)
            {
                return true;
            }
            if (check.Value == "true")
            {
                return true;
            }
            return false;
        }

        public int GetNoticeHash()
        {
            return new WebClient().DownloadString(NoticeUrl).GetHashCode();
        }

        public async Task<int> GetNoticeHashAsync()
        {
            return (await new WebClient().DownloadStringTaskAsync(NoticeUrl)).GetHashCode();
        }
    }
}
