﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Collections.Specialized;
using CreteLib;

namespace Progressive.PecaStarter.Util
{
    public static class PeercastUtils
    {
        public static bool ToSettings(string source, out IList<string[]> nvc)
        {
            var html = new HtmlDocument();
            html.LoadHtml(source, true);
            nvc = html.GetNodesByTagName("form")[0].GetParameters();
            string[] cmd = { "", "" };
            foreach (var item in nvc)
            {
                if (item[0] == "cmd")
                {
                    cmd = item;
                    break;
                }
            }
            if (cmd[0] == "")
            {
                nvc = null;
                return false;
            }
            nvc.Remove(cmd);
            return true;
        }
    }
    static class ExtensionsOnSettingsHtml
    {
        static public IList<string[]> GetParameters(this HtmlNode form)
        {
            var dictionary = new List<string[]>();
            foreach (HtmlNode node in form.ChildNodes)
            {
                if ("input".EqualsIgnoreCase(node.TagName))
                {
                    dictionary.AddFromInputNode(node);
                    continue;
                }
                if ("select".EqualsIgnoreCase(node.TagName))
                {
                    dictionary.AddFromSelectNode(node);
                    continue;
                }
                dictionary.AddAll(node.GetParameters());
            }
            return dictionary;
        }

        static private void AddFromSelectNode(this IList<string[]> list, HtmlNode node)
        {
            string value = "";
            foreach (HtmlNode option in node.ChildNodes)
            {
                if (option.Attributes.ContainsKey("selected"))
                {
                    value = option.Attributes["value"];
                    break;
                }
            }
            list.Add(Create(node.Attributes["name"], value));
        }

        static private void AddFromInputNode(this IList<string[]> list, HtmlNode node)
        {
            if (!node.Attributes.ContainsKey("type"))
            {
                list.AddParameter(node);
                return;
            }
            var type = node.Attributes["type"];
            if (!"radio".EqualsIgnoreCase(type) && !"checkbox".EqualsIgnoreCase(type))
            {
                list.AddParameter(node);
                return;
            }
            if (node.Attributes.ContainsKey("checked"))
            {
                list.AddParameter(node);
                return;
            }
        }

        static private void AddParameter(this IList<string[]> List, HtmlNode node)
        {
            if (!node.Attributes.ContainsKey("value"))
            {
                List.Add(Create(node.Attributes["name"], ""));
                return;
            }
            List.Add(Create(node.Attributes["name"], node.Attributes["value"].Replace(' ', '+')));
        }

        static private bool EqualsIgnoreCase(this string source, string target)
        {
            return source.Equals(target, StringComparison.OrdinalIgnoreCase);
        }

        static private void AddAll(this IList<string[]> t, IList<string[]> source)
        {
            foreach (var item in source)
            {
                t.Add(item);
            }
        }

        private static string[] Create(string key, string value)
        {
            return new string[] { key, value };
        }
    }
}
