﻿using System;
using System.Collections.Generic;
using System.Xml.Linq;
using Progressive.PecaStarter.Common;
using Progressive.PecaStarter.DTO;
using Progressive.PecaStarter.Entity;

namespace Progressive.PecaStarter.Model.Peercast
{
    class XmlStatus
    {
        private XDocument xml;

        public XmlStatus(string source)
        {
            xml = XDocument.Parse(source);
        }

        public Channel[] Channels
        {
            get
            {
                var channels = new List<Channel>();
                foreach (XElement channel in GetChannelElements(xml))
                {
                    channels.Add(CreateChannel(channel));
                }
                return channels.ToArray();
            }
        }

        public bool IsExistOnRelaysByName(string name)
        {
            foreach (XAttribute nameAttribute in GetChannelElements(xml).Attributes("name"))
            {
                if (nameAttribute.Value == name)
                {
                    return true;
                }
            }
            return false;
        }

        public bool IsExistOnRelaysById(string id)
        {
            foreach (XAttribute idAttribute in GetChannelElements(xml).Attributes("id"))
            {
                if (idAttribute.Value == id)
                {
                    return true;
                }
            }
            return false;
        }

        public bool IsAgreementChannelStatus(UpdateDTO entity)
        {
            foreach (XElement channel in GetChannelElements(xml))
            {
                if (channel.Attribute("name").Value == entity.Name &&
                    channel.Attribute("genre").Value == entity.Genre &&
                    channel.Attribute("desc").Value == entity.Description &&
                    channel.Attribute("url").Value == entity.Url &&
                    channel.Attribute("comment").Value == entity.Comment)
                {
                    XElement track = channel.Element("track");
                    if (track.Attribute("title").Value == entity.TrackTitle &&
                        track.Attribute("artist").Value == entity.TrackArtist &&
                        track.Attribute("album").Value == entity.TrackAlbum &&
                        track.Attribute("genre").Value == entity.TrackGenre &&
                        track.Attribute("contact").Value == entity.TrackContact)
                    {
                        return true;
                    }
                }
            }
            return false;
        }

        public string GetChannelId(string name)
        {
            foreach (XElement channel in GetChannelElements(xml))
            {
                if (channel.Attribute("name").Value == name)
                {
                    return channel.Attribute("id").Value;
                }
            }
            return PeercastDefine.NULL_RELAY_ID;
        }

        public Hits GetListeners(string name)
        {
            foreach (XElement channel in xml.Element("peercast").Elements("channels_found").Elements("channel"))
            {
                if (channel.Attribute("name").Value != name)
                {
                    continue;
                }
                XElement hit = channel.Element("hits");
                return new Hits()
                {
                    Listeners = int.Parse(hit.Attribute("listeners").Value),
                    Relays = int.Parse(hit.Attribute("hosts").Value)
                };
            }
            throw new ApplicationException();
        }

        private IEnumerable<XElement> GetChannelElements(XDocument xml)
        {
            return xml.Element("peercast").Elements("channels_relayed").Elements("channel");
        }

        private Channel CreateChannel(XElement channel)
        {
            var trackElement = channel.Element("track");
            return new Channel()
            {
                Name = channel.Attribute("name").Value,
                Id = channel.Attribute("id").Value,
                Type = (Progressive.PecaStarter.Common.Type)Enum.Parse(typeof(Common.Type), channel.Attribute("type").Value),
                Genre = channel.Attribute("genre").Value,
                Desc = channel.Attribute("desc").Value,
                Url = channel.Attribute("url").Value,
                Comment = channel.Attribute("comment").Value,
                Relay = new Relay()
                {
                    Status = (Status)Enum.Parse(typeof(Status), channel.Element("relay").Attribute("status").Value)
                },
                Track = new Track()
                {
                    Title = trackElement.Attribute("title").Value,
                    Artist = trackElement.Attribute("artist").Value,
                    Album = trackElement.Attribute("album").Value,
                    Genre = trackElement.Attribute("genre").Value,
                    Contact = trackElement.Attribute("contact").Value
                }
            };
        }
    }
}
