﻿using System;
using System.Threading;
using Progressive.PecaStarter.Entity;
using Progressive.PecaStarter.Model;
using Progressive.PecaStarter.Model.Peercast;

namespace Progressive.PecaStarter.Service
{
    public class LogAsyncService
    {
        private static Timer Timer;

        static LogAsyncService()
        {
            Timer = null;
        }

        public void Logging(string path, string server, DateTime startAt, string name, string genre, string description, string comment)
        {
            EndTimer();
            var hits = new Peercast(server).XmlStatus.GetListeners(name);
            new Logger(path, name, startAt).logging(new Log
            {
                DateTime = DateTime.Now,
                Listeners = hits.Listeners,
                Relays = hits.Relays,
                Genre = genre,
                Description = description,
                Comment = comment
            });
            BeginTimer(path, server, startAt, name);
        }

        public void Stop(string path, string server, DateTime startAt, string name)
        {
            EndTimer();
            var hits = new Peercast(server).XmlStatus.GetListeners(name);
            new Logger(path, name, startAt).logging(new Log
            {
                DateTime = DateTime.Now,
                Listeners = hits.Listeners,
                Relays = hits.Relays,
                Genre = "",
                Description = "",
                Comment = "(配信終了)"
            });
        }

        public void EndTimer()
        {
            if (Timer == null)
            {
                return;
            }
            Timer.Dispose();
            Timer = null;
        }

        private void BeginTimer(string path, string server, DateTime startAt, string name)
        {
            Timer = new Timer((obj) =>
            {
                var asyncHits = new Peercast(server).XmlStatus.GetListeners(name);
                new Logger(path, name, startAt).logging(new Log
                {
                    DateTime = DateTime.Now,
                    Listeners = asyncHits.Listeners,
                    Relays = asyncHits.Relays,
                    Genre = "",
                    Description = "",
                    Comment = ""
                });
            }, null, 0, 10 * 60 * 1000);
        }
    }
}
