﻿namespace Progressive.PecaStarter.Util
{
    class Tokenizer
    {
        private string Source;
        private int Index;

        public Tokenizer(string source)
        {
            this.Source = source;
            this.Index = 0;
        }

        public bool TryOverTo(string data)
        {
            if (Source.Length - Index < data.Length || data != Source.Substring(Index, data.Length))
            {
                return false;
            }
            Index += data.Length;
            return true;
        }

        public string ReadToSign(string sign)
        {
            int i = Source.Substring(Index).IndexOf(sign);
            if (i < 0)
            {
                return "";
            }
            string rtn = Source.Substring(Index, i);
            Index += i + 1;
            return rtn;
        }

        public string ReadToEnd()
        {
            return Source.Substring(Index);
        }
    }
}
