﻿using System;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;
using Progressive.PecaStarter.Entity;

namespace Progressive.PecaStarter.DAO
{
    public class SaveDataDAOBinaryImpl : SaveDataDAO
    {
        private const string fileName = "pecastarter.dat";

        public void Update(SaveData saveData)
        {
            using (var fs = new FileStream(fileName, FileMode.Create))
            {
                new BinaryFormatter().Serialize(fs, saveData);
            }
        }

        public SaveData Select()
        {
            try
            {
                using (var fs = new FileStream(fileName, FileMode.Open))
                {
                    return new BinaryFormatter().Deserialize(fs) as SaveData;
                }
            }
            catch (Exception)
            {
                return null;
            }
        }
    }
}
