﻿using Progressive.PecaStarter.Common;
using Progressive.PecaStarter.DTO;
using Progressive.PecaStarter.Service;
using System;
using System.Collections.Generic;
using Progressive.PecaStarter.Model.Peercast;

namespace Progressive.PecaStarter.ViewModel.Command
{
    class UpdateCommand : AsyncCommandBase
    {
        public UpdateCommand(BroadcastViewModel viewModel) : base(viewModel) { }

        public override bool CanExecute(object parameter)
        {
            if (ViewModel.Id == PeercastDefine.NULL_RELAY_ID)
            {
                return false;
            }
            if (!ViewModel.IsAvailable)
            {
                return false;
            }
            return true;
        }

        protected override object AsyncExecute(object parameter)
        {
            ViewModel.Save();
            var externalSource = ViewModel.ExternalSourceViewModel;
            var currentTrack = ViewModel.CurrentTrackViewModel;
            var dto = new UpdateDTO()
            {
                Name = externalSource.Name.Text,
                Genre = ViewModel.YellowPagesViewModel.SelectedYellowPages.Prefix + externalSource.Genre.Text,
                Description = externalSource.Description.Text,
                Url = externalSource.Contact.Text,
                Comment = externalSource.Comment.Text,
                TrackArtist = currentTrack.Artist.Text,
                TrackTitle = currentTrack.Title.Text,
                TrackAlbum = currentTrack.Album.Text,
                TrackGenre = currentTrack.Genre.Text,
                TrackContact = currentTrack.Contact.Text,
            };
            new PeercastService().Update(ViewModel.SettingsViewModel.ServerAddress, ViewModel.YellowPagesViewModel.SelectedYellowPages.Host, dto);
            UpdateWebApi();
            var settings = ViewModel.SettingsViewModel;
            if (settings.Logging)
            {
                new LogAsyncService().Logging(settings.LogPath, settings.ServerAddress, ViewModel.StartAt, externalSource.Name.Text, externalSource.Genre.Text, externalSource.Description.Text, externalSource.Comment.Text);
            }
            return null;
        }

        private void UpdateWebApi()
        {
            foreach (var webApi in ViewModel.WebApisViewModel.WebApis)
            {
                if (!webApi.IsAccepted || !webApi.IsEnabled)
                {
                    continue;
                }
                var extSrcVM = ViewModel.ExternalSourceViewModel;
                var list = new List<KeyValuePair<string, string>>();
                Add(list, "name", extSrcVM.Name.Text);
                Add(list, "tags", extSrcVM.Genre.Text);
                Add(list, "description", extSrcVM.Description.Text);
                Add(list, "comment", extSrcVM.Comment.Text);
                Add(list, "contact_url", extSrcVM.Contact.Text);
                Add(list, "protocol", "Peercast");
                Add(list, "broadcast_url", "http://localhost:7144/pls/" + ViewModel.Id);
                Add(list, "type", extSrcVM.Type);
                Add(list, "password", webApi.Options.Find((i) => { return i.Type == "password"; }).Value);
                Add(list, "time_visibility", webApi.Options.Find((i) => { return i.Type == "time_visibility"; }).Value);
                new WebApi().GetResponse(Array.Find(webApi.Definition.methods, (o) => { return o.type == "update"; }).url, list);
            }
        }

        private void Add(List<KeyValuePair<string, string>> list, string key, string value)
        {
            list.Add(new KeyValuePair<string, string>(key, value));
        }
    }
}
