﻿using System;
using System.Runtime.InteropServices;
using System.Windows;
using System.Windows.Interop;
using System.Windows.Media;

namespace Progressive.PecaStarter.View.WPF
{
    abstract public class GlassWindow : Window
    {
        // DWM の dll をロード
        [DllImport("dwmapi.dll", PreserveSig = false)]
        static extern void DwmExtendFrameIntoClientArea(IntPtr hwnd, ref MARGINS margins);
        [DllImport("dwmapi.dll", PreserveSig = false)]
        static extern bool DwmIsCompositionEnabled();

        private const int WINDOWS_VISTA = 6;

        private bool haveDwm;
        private IntPtr hwnd;
        private MARGINS margins;

        public GlassWindow()
        {
            haveDwm = HaveDwm();
            margins = new MARGINS(new Thickness(-1));
        }
        protected override void OnSourceInitialized(EventArgs e)
        {
            InitializeGlass();
            base.OnSourceInitialized(e);
        }
        protected override void OnActivated(EventArgs e)
        {
            UpdateGlass();
            base.OnActivated(e);
        }
        private bool HaveDwm()
        {
            if (Environment.OSVersion.Version.Major < WINDOWS_VISTA)
            {
                return false;
            }
            try
            {
                // DLLの存在チェック
                DwmIsCompositionEnabled();
            }
            catch (DllNotFoundException)
            {
                return false;
            }
            return true;
        }
        private void InitializeGlass()
        {
            if (!haveDwm)
            {
                return;
            }
            hwnd = new WindowInteropHelper(this).Handle;
            if (hwnd == IntPtr.Zero)
                throw new InvalidOperationException();
            HwndSource.FromHwnd(hwnd).CompositionTarget.BackgroundColor = Colors.Transparent;
            UpdateGlass();
        }
        private void UpdateGlass()
        {
            if (!haveDwm || !DwmIsCompositionEnabled())
            {
                this.Background = SystemColors.ControlBrush;
                return;
            }
            this.Background = Brushes.Transparent;
            DwmExtendFrameIntoClientArea(hwnd, ref margins);
        }
    }

    struct MARGINS
    {
        public MARGINS(Thickness t)
        {
            Left = (int)t.Left;
            Right = (int)t.Right;
            Top = (int)t.Top;
            Bottom = (int)t.Bottom;
        }
        public int Left;
        public int Right;
        public int Top;
        public int Bottom;
    }
}
