<?php

// PukiWiki - Yet another WikiWikiWeb clone.
// $Id: plugin.php,v 1.20 2011/01/25 15:01:01 henoheno Exp $
// Copyright (C)
//   2002-2005, 2007 PukiWiki Developers Team
//   2001-2002 Originally written by yu-ji
// License: GPL v2 or (at your option) any later version
//
// Plugin related functions
/**/

define('PKWK_PLUGIN_CALL_TIME_LIMIT', 768);

// Set global variables for plugins
function set_plugin_messages( $messages )
{
    foreach ( $messages as $name => $val )
        if ( !isset($GLOBALS[$name]) )
            $GLOBALS[$name] = $val;
}

// Check plugin '$name' is here
function regacy_exist_plugin( $name )
{
    global $vars;
    static $exist = array();

//    $exist : 'exist' , 'enabled' , 'activation' , 'count'

    $name = strtolower($name);
    if ( isset($exist[$name]) )
    {
        if ( $exist[$name]['count'] + 1 > PKWK_PLUGIN_CALL_TIME_LIMIT )
        {
            die('Alert: plugin "' . HtmlUtils::escapeHTML($name) .
                    '" was called over ' . PKWK_PLUGIN_CALL_TIME_LIMIT .
                    ' times. SPAM or someting?<br />' . "\n" .
                    '<a href="' . get_script_uri() . '?cmd=edit&amp;page=' .
                    rawurlencode($vars['page']) . '">Try to edit this page</a><br />' . "\n" .
                    '<a href="' . get_script_uri() . '">Return to frontpage</a>');
        }
        $exist[$name]['count'] += 1;

        return $exist[$name]['exist'] && $exist[$name]['activation'] && $exist[$name]['enabled'];
    }

    $exist[$name] = array('count' => 1
        , 'exist' => FALSE
        , 'activation' => FALSE, 'enabled' => FALSE);

    if ( preg_match('/^\w{1,64}$/', $name) &&
            file_exists(PLUGIN_DIR . $name . '.inc.php') )
    {
        global $load_plugin_list, $non_plugin_list;
//        global $enabled_plugin_list;

        $exist[$name]['exist'] = TRUE;

        if ( isset($non_plugin_list) )
        {
            if ( is_string($non_plugin_list) )
            {
                $non_plugin_list = array($non_plugin_list);
            }
            if ( is_array($non_plugin_list) && count($non_plugin_list) > 0 )
            {
                foreach ( $non_plugin_list as $pattern )
                {
                    if ( is_string($pattern) && ($pattern !== '') && preg_match('/' . $pattern . '/i', $name) )
                        return FALSE;
                }
            }
        }

        if ( !isset($load_plugin_list) )
        {
            die_message(' <b style="color:red">$load_plugin_list</b> is not set. <br>');
        }

        if ( isset($load_plugin_list) )
        {
            if ( is_string($load_plugin_list) )
                $non_plugin_list = array($load_plugin_list);
            if ( is_array($load_plugin_list) && count($load_plugin_list) > 0 )
                foreach ( $load_plugin_list as $pattern )
                {
                    if ( is_string($pattern) && ($pattern !== '') && preg_match('/' . $pattern . '/i', $name) )
                    {
                        $exist[$name]['activation'] = TRUE;
                        $exist[$name]['enabled'] = TRUE; // reserved
                        break;
                    }
                }
        }

// reserved,  Todo: admin area.
//        if ( $exist[$name]['activation'] )
//        {
//            if ( in_array($name, $enabled_plugin_list) )
//                $exist[$name]['enabled'] = TRUE;
//        }

        if ( $exist[$name]['exist'] && $exist[$name]['activation'] && $exist[$name]['enabled'] )
        {
            require_once(PLUGIN_DIR . $name . '.inc.php');
            return TRUE;
        }
    }
    return FALSE;
}

function exist_plugin( $name )
{
    // This function is not used in core 1.4.8.
    // warn : remove message
//    $warn_msg = 'function ' . __FUNCTION__ . ' : will be removed in nearly future';
//    trigger_error($warn_msg, E_USER_NOTICE); // E_USER_NOTICE , E_USER_DEPRECATED
    return regacy_exist_plugin($name);
}

// Return TRUE if the given plugin API function has been defined.
function regacy_exists_plugin_function( $plugin_name, $api_name )
{
    $func_name = 'plugin_' . $plugin_name . '_' . $api_name;
    return function_exists($func_name) ?
            TRUE : (regacy_exist_plugin($plugin_name) ? function_exists($func_name) : FALSE);
}

// Return TRUE if plugin API 'action' has been existed
function exist_plugin_action( $plugin_name )
{
    return regacy_exists_plugin_function($plugin_name, 'action');
}

// Return TRUE if plugin API 'convert' has been existed
function exist_plugin_convert( $plugin_name )
{
    return regacy_exists_plugin_function($plugin_name, 'convert');
}

// Return TRUE if plugin API 'inline' has been existed
function exist_plugin_inline( $plugin_name )
{
    return regacy_exists_plugin_function($plugin_name, 'inline');
}

// Call 'init' function for the plugin
// NOTE: Returning FALSE means "An erorr occurerd"
function do_plugin_init( $name )
{
    static $done = array();

    if ( !isset($done[$name]) )
    {
        $func = 'plugin_' . $name . '_init';
        $done[$name] = (!function_exists($func) || call_user_func($func) !== FALSE);
    }

    return $done[$name];
}

// Call API 'action' of the plugin
function do_plugin_action( $name )
{
    if ( !exist_plugin_action($name) )
        return array();

    if ( do_plugin_init($name) === FALSE )
    {
        die_message('Plugin init failed: ' . HtmlUtils::escapeHTML($name));
    }

    $retvar = call_user_func('plugin_' . $name . '_action');

    // Insert a hidden field, supports idenrtifying text enconding
    if ( PKWK_ENCODING_HINT != '' )
        $retvar = preg_replace('/(<form[^>]*>)/', '$1' . "\n" .
                '<div><input type="hidden" name="encode_hint" value="' .
                PKWK_ENCODING_HINT . '" /></div>', $retvar);

    return $retvar;
}

// Call API 'convert' of the plugin
function do_plugin_convert( $name, $args = '' )
{
    global $digest;

    if ( do_plugin_init($name) === FALSE )
    {
        return '[Plugin init failed: ' . HtmlUtils::escapeHTML($name) . ']';
    }

    if ( !PKWKEXP_DISABLE_MULTILINE_PLUGIN_HACK )
    {
        // Multiline plugin?
        $pos = strpos($args, "\r"); // "\r" is just a delimiter
        if ( $pos !== FALSE )
        {
            $body = substr($args, $pos + 1);
            $args = substr($args, 0, $pos);
        }
    }

    if ( $args === '' )
    {
        $aryargs = array();                 // #plugin()
    }
    else
    {
        $aryargs = csv_explode(',', $args); // #plugin(A,B,C,D)
    }
    if ( !PKWKEXP_DISABLE_MULTILINE_PLUGIN_HACK )
    {
        if ( isset($body) )
            $aryargs[] = & $body;     // #plugin(){{body}}
    }

    $_digest = $digest;
    $retvar = call_user_func_array('plugin_' . $name . '_convert', $aryargs);
    $digest = $_digest; // Revert

    if ( $retvar === FALSE )
    {
        return HtmlUtils::escapeHTML('#' . $name .
                        ($args != '' ? '(' . $args . ')' : ''));
    }
    else if ( PKWK_ENCODING_HINT != '' )
    {
        // Insert a hidden field, supports idenrtifying text enconding
        return preg_replace('/(<form[^>]*>)/', '$1 ' . "\n" .
                '<div><input type="hidden" name="encode_hint" value="' .
                PKWK_ENCODING_HINT . '" /></div>', $retvar);
    }
    else
    {
        return $retvar;
    }
}

// Call API 'inline' of the plugin
function do_plugin_inline( $name, $args, & $body )
{
    global $digest;

    if ( do_plugin_init($name) === FALSE )
    {
        return '[Plugin init failed: ' . HtmlUtils::escapeHTML($name) . ']';
    }

    if ( $args === '' )
    {
        $aryargs = array();
    }
    else
    {
        $aryargs = csv_explode(',', $args);
    }

    // NOTE: A reference of $body is always the last argument
    $aryargs[] = & $body; // func_num_args() != 0

    $_digest = $digest;
    $retvar = call_user_func_array('plugin_' . $name . '_inline', $aryargs);
    $digest = $_digest; // Revert

    if ( $retvar === FALSE )
    {
        // Do nothing
        return HtmlUtils::escapeHTML('&' . $name . ($args ? '(' . $args . ')' : '') . ';');
    }
    else
    {
        return $retvar;
    }
}
