<?php
App::uses('Controller', 'Controller');

/**
 * primocco基底コントローラ
 *
 * @author pippine
 *
 */
abstract class AppController extends Controller {

	public $uses = array("System");

	protected $SESSION_KEY_USER = "user";
	protected $SESSION_KEY_IMAGE1 = "image1";

	/**
	 * 各コントローラで事前処理をする場合はこのメソッドの中身を実装してください
	 */
	protected abstract function appFilter();

	public function beforeFilter() {
		$systemInfo = $this->System->find("first");
		// メンテナンス判定
		if ($systemInfo["System"]["maintenance_flag"] == 1) {
			$this->redirect("/primoccoError/maintenanceError");
		} else {
			$this->appFilter();
		}
	}

	public function badRequestError() {
		$this->redirect("/primoccoError/badRequestError");
	}

	protected function getUser() {
		return $this->Session->read("user");
	}

	protected function sessionDestroy() {
		$this->Session->delete($this->SESSION_KEY_USER);
		$this->Session->delete($this->SESSION_KEY_IMAGE1);
	}

}
