<?php
/**
 * リスト用コントローラ
 *
 * @author pippine
 *
 */
class ListController extends AppController {

	public $uses = array("Category","User");

	var $paginate = array(
			'limit' => 10,
			'fields' => array('title','domain'),
			'order' => array('User.created' => 'DESC'),
	);

	protected function appFilter() {

	}

	public function search() {
		if (!empty($this->params['url']['keyword'])) {
			$keyword = $this->params['url']['keyword'];
			$this->paginate['conditions']['title LIKE']  = "%{$keyword}%";
			$result = $this->paginate('User');
			$this->set("viewDataList", $result);
			$this->set("keyword",$keyword);
			$this->render("search_result");
		} else {
			$this->set("error", "検索キーワードが指定されていません");
			$this->render("search_result");
		}
	}

	public function index() {
		if (!array_key_exists(0,$this->params['pass'])){
			$this->set("error", "categoryが指定されていません");
			$this->render("search_result");
		}
		$category = $this->params['pass'][0];
		if (!is_numeric($category)) {
			$this->set("error", "categoryが正しく指定されていません");
			$this->render("search_result");
		}
		$this->set("category", $this->Category->findById($category));
		$this->paginate['conditions']['category_id'] = $category;

		$categoryDataList = $this->paginate('User');

		if (empty($categoryDataList)){
			$this->set("error", "ポスターが存在しません");
			$this->render("search_result");
		}

		$this->set("viewDataList",$categoryDataList);

		$this->render("list");
	}

}