<?php
App::uses('AppController', 'Controller');

/**
 * インデックス用コントローラ
 *
 * @author pippine
 *
 */
class PagesController extends AppController {

	public $name = 'Pages';
	public $uses = array("Category","User");

	protected function appFilter() {

	}

	/**
	 * トップページを表示する
	 */
	public function display() {
		$path = func_get_args();

		$count = count($path);
		if (!$count) {
			$this->redirect('/');
		}
		$page = $subpage = $title_for_layout = null;

		if (!empty($path[0])) {
			$page = $path[0];
		}
		if (!empty($path[1])) {
			$subpage = $path[1];
		}
		if (!empty($path[$count - 1])) {
			$title_for_layout = Inflector::humanize($path[$count - 1]);
		}
		$this->set(compact('page', 'subpage', 'title_for_layout'));
		$this->set("categoryList", $this->Category->find("all"));
		$this->set("newDataList", $this->User->find("all",array('order' => array('User.created DESC'),
																	'limit'  => 10)));
		$this->render(implode('/', $path));
	}

}
