#pragma once

#include "ColladaGeom.h"

#define TIXML_USE_STL
#include <tinyxml.h>


namespace lib_geo
{


class DaeMeshSource : public NamedElement
{
public:
	DaeMeshSource(void)
		: m_ElemCount(0)
		, m_Stride(0)
	{}

public:
	std::vector<float>  m_Values;
	int                 m_ElemCount;
	int                 m_Stride;
};

class DaeVertexCache : public NamedElement
{
public:
	std::map<std::string, DaeMeshSource> m_VertSources;
};


class ColladaFileLoader
{
public:
	ColladaFileLoader(void)
		: m_TargetGeom(NULL)
	{}

public:
	bool Load(const char* filename, ColladaGeom& geom);

private:
	bool LoadMain(const char* filename);

	void LoadMesh(TiXmlElement* elem);
	void LoadMeshSource(TiXmlElement* elem, DaeVertexCache& vert_cache);
	void LoadMeshPolylist(TiXmlElement* elem, DaeVertexCache& vert_cache);

	void LoadVisualScene(TiXmlElement* elem);
	void LoadVisualSceneNode(TiXmlElement* elem, ColladaNode& node);

	void LoadController(TiXmlElement* elem);
	void LoadControllerSkin(TiXmlElement* elem);

private:
	ColladaGeom* m_TargetGeom;
};


}
