#pragma once

#include <boost/algorithm/string.hpp>



namespace lib_geo
{


// Xg[̍s܂Ői߂
inline void ReadToNextLine(std::istream& ist)
{
	char c;
	for(;;)
	{
		ist.read( &c , sizeof(c) );
		if( ist.eof() || c == '\n' )
			break;
	}
}

inline void TrimStr(std::string& s)
{
	typedef std::string::size_type size_type;
	const char* delim=" \t\r\n";

	size_type p1 = s.find_first_not_of(delim);
	if(p1 == std::string::npos)
	{
		s.clear();
		return;
	}

	size_type p2 = s.find_last_not_of(delim);
	s = s.substr(p1, p2 - p1 + 1);
}

inline void GetLineWithTrimed(std::istream& ist, std::string& line)
{
	getline(ist, line);
	TrimStr(line);
}


}
