#pragma once

#include <vector>



namespace lib_geo
{


//! Obj`̃|S
class ObjFace
{
public:
	ObjFace(void)
		: m_MatNameIdx(-1)
		, m_GroupIdx(0)
	{}

	void Clear(void)
	{
		m_IdxV.clear();
		m_IdxN.clear();
		m_IdxUV.clear();

		m_MatNameIdx = -1;
		m_GroupIdx = 0;
	}

	bool HasValidMatIdx(void) const
	{
		return m_MatNameIdx != -1;
	}


public:
	std::vector<int> m_IdxV;
	std::vector<int> m_IdxN;
	std::vector<int> m_IdxUV;

	int m_MatNameIdx;
	int m_GroupIdx;
};


class ObjPolyline
{
public:
	ObjPolyline(void)
	{
		m_GroupIdx = 0;
	}

	void Clear(void)
	{
		m_IdxV.clear();
		m_GroupIdx = 0;
	}

public:
	std::vector<int> m_IdxV;
	int m_GroupIdx;
};


}
