#include "StdAfx.h"
#include "FullScreenPanel.h"

#include <QKeyEvent>



FullScreenPanel::FullScreenPanel(QWidget *parent)
	: QWidget(parent)
{
	ui.setupUi(this);
	m_PrevLayout = NULL;
	m_Target = NULL;
}

FullScreenPanel::~FullScreenPanel()
{
}

void FullScreenPanel::ShowWidgetAsFullscreen(QWidget* w, QLayout* parent)
{
	m_Target = w;
	m_PrevLayout = parent;

	ui.gridLayout->addWidget(w);

	showFullScreen();
}

void FullScreenPanel::closeEvent(QCloseEvent *e)
{
	if(m_Target == NULL)
		return;

	m_PrevLayout->addWidget(m_Target);
	m_PrevLayout = NULL;
	m_Target = NULL;
}

void FullScreenPanel::on_actionActionClose_triggered()
{
	close();
}

void FullScreenPanel::on_buttonClose_clicked()
{
	close();
}

void FullScreenPanel::keyPressEvent(QKeyEvent *e)
{
	if(e->key() == Qt::Key_Escape)
	{
		close();
		return;
	}
}
