varying vec3 v_position;

uniform sampler2D tex_color;
uniform sampler2D tex_depth;

uniform int tex_width;
uniform int tex_height;



void main (void)
{
	float tx = v_position.x * 0.5 + 0.5;
	float ty = v_position.y * 0.5 + 0.5;
	vec4 uv = vec4(tx, ty, 0.0, 1.0);

	float nx = 1.0 / tex_width;
	float ny = 1.0 / tex_height;
	vec4 diff_x = vec4( nx , 0.0 , 0.0 , 0.0 );
	vec4 diff_y = vec4( 0.0 , ny , 0.0 , 0.0 );

	// numpad coordinate
	float h5 = texture2DProj(tex_color, uv).x;
	float h4 = texture2DProj(tex_color, uv - diff_x).x;
	float h6 = texture2DProj(tex_color, uv + diff_x).x;
	float h8 = texture2DProj(tex_color, uv + diff_y).x;
	float h2 = texture2DProj(tex_color, uv - diff_y).x;

	float dx = max(abs(h4 - h5), abs(h6 - h5));
	float dy = max(abs(h2 - h5), abs(h8 - h5));

	float blend = 0.75;

	gl_FragColor = vec4(dx, dy, 0.0, 1.0) * blend;
	gl_FragColor.xyz += texture2DProj(tex_color, uv).xyz * (1.0 - blend);
	if (gl_FragColor.x > 1.0) gl_FragColor.x = 1.0;
	if (gl_FragColor.y > 1.0) gl_FragColor.y = 1.0;
	if (gl_FragColor.z > 1.0) gl_FragColor.z = 1.0;
}
