/*

	Copyright (C) 2012 by Nobuhide Tsuda

	RuviEdit ̃CZX MIT{GPL ȃCZXłB 
	ۏ؁ET|[głAŗpłApAvł\[XR[h𗬗p邱Ƃ\łB 
	i\[XR[h𗬗pꍇAp̒쌠ECZXRuviEdit̂̂܂܂łj 
	M҂́AvO}ɂƂĕsRɂ܂Ȃ̂ɎRRƌGPLnȂ̂ŁA 
	RuviEdit ̃\[XGPLnvWFNgŎgp邱Ƃ֎~܂B 
	GPLvWFNgł͈؂̗p֎~܂ALGPLvWFNgł͓INɂ闬p͋܂B

*/

#include "OutlineTokenizer.h"
//#include "EditView.h"
#include <QTextDocument>

/**

gp@F
	IuWFNgF	OutlineTokenizer tn(dcoument)
	_ŁAŏ̃g[Nǂݍ܂
	tn.tokenType(), tn.tokenText(), tn.tokenLine() ȂǂŃg[N
	ɃANZX\

	̃g[Nǂݍނɂ tn.nextToken() Ă

	tn.tokenType() == END_OF_FILE Ȃ΁Ag[Ns

*/

bool isLetterOrNumberOrUnderbar(const QChar &ch);

OutlineTokenizer::OutlineTokenizer(QTextBlock &block)
	: m_block(block)
{
	m_pushed = false;
	if( !m_block.isValid() ) {
		m_tokenType = END_OF_FILE;
	} else {
		m_buffer = m_block.text();
		//m_firstTokenRead = false;
		m_ix = 0;
		m_lineNum = 1;
		m_tokenType = UNDEF;
		nextToken();
	}
}


OutlineTokenizer::~OutlineTokenizer(void)
{
}
QChar OutlineTokenizer::nextChar()
{
	if( m_ix < m_buffer.length() )
		return m_buffer[m_ix];
	else
		return QChar();
}
bool OutlineTokenizer::nextBlock()
{
	m_block = m_block.next();
	if( !m_block.isValid() ) return false;
	m_buffer = m_block.text();
	if( m_buffer == "__END__" ) return false;	//	__END__ ȍ~͖
	m_ix = 0;
	m_lineNum += 1;
	return true;
}
uchar OutlineTokenizer::nextToken()
{
	if( m_tokenType == END_OF_FILE ) return END_OF_FILE;
	m_prevText = m_tokenText;
	for(;;) {
		m_firstToken = m_ix == 0;
		while( m_ix < m_buffer.length() && m_buffer[m_ix].isSpace() )
			++m_ix;
		if( m_ix >= m_buffer.length() || m_buffer[m_ix] == QChar('#') ) {
			if( !nextBlock() ) break;
			continue;
		}
		if( m_ix == 0 && m_buffer.startsWith("=begin") ) {
			for(;;) {
				if( !nextBlock() ) return m_tokenType = END_OF_FILE;
				if( m_buffer.startsWith("=end") ) {
					if( !nextBlock() ) return m_tokenType = END_OF_FILE;
					break;
				}
			}
			continue;
		}
		m_tokenLineNum = m_lineNum;
		m_tokenOffset = m_ix;
		if( m_buffer[m_ix].isNumber() ) {
			while( ++m_ix < m_buffer.length() && m_buffer[m_ix].isLetterOrNumber() ) {}
			m_tokenText = m_buffer.mid(m_tokenOffset, m_ix - m_tokenOffset);
			return m_tokenType = NUMBER;
		}
		if( isLetterOrNumberOrUnderbar(m_buffer[m_ix]) ) {
			while( ++m_ix < m_buffer.length() && isLetterOrNumberOrUnderbar(m_buffer[m_ix]) ) {}
			m_tokenText = m_buffer.mid(m_tokenOffset, m_ix - m_tokenOffset);
			return m_tokenType = IDENT;
		}
		if( m_buffer[m_ix] == QChar('\"') || m_buffer[m_ix] == QChar('\'') ) {
			QChar sep = m_buffer[m_ix++];
			while( m_ix < m_buffer.length() ) {
				QChar c = m_buffer[m_ix++];
				if( c == sep )
					break;
				if( c == '\\' && m_ix < m_buffer.length() )
					++m_ix;
			}
			m_tokenText = m_buffer.mid(m_tokenOffset, m_ix - m_tokenOffset);
			return m_tokenType = STRING;
		}
		m_tokenText = m_buffer[m_ix++];
		if( m_tokenText == QChar('<')
			&& m_ix < m_buffer.length()
			&& m_buffer[m_ix] == QChar('<') )	//	<< ͂ЂƂ̃g[Nɂ
		{
			m_tokenText += QChar('<');
			++m_ix;
		}
		if( (m_tokenText == QChar('!') || m_tokenText == QChar('=') ||
			m_tokenText == QChar('>') || m_tokenText == QChar('<'))
			&& m_ix < m_buffer.length()
			&& m_buffer[m_ix] == QChar('=') )	//	== ܂ != ܂ >= ܂ <= ͂ЂƂ̃g[Nɂ
		{
			m_tokenText += QChar('=');
			++m_ix;
		}
		return m_tokenType = SYMBOL;
	}
	return m_tokenType = END_OF_FILE;
}
