#include <QtGui>
#include "TabbedMainWindow.h"

QHash<QString, uint> g_cmdStatistics;
void incCmdStatistics(const QString &keyText)
{
	if( keyText.isEmpty() ) return;
	if( g_cmdStatistics.find(keyText) == g_cmdStatistics.end() ) {
		g_cmdStatistics.insert(keyText, 1);
	} else {
		g_cmdStatistics[keyText] += 1;
	}
}

TabbedMainWindow::TabbedMainWindow(QWidget *parent, Qt::WFlags flags)
	: QMainWindow(parent, flags)
{
	init();
}

TabbedMainWindow::~TabbedMainWindow()
{

}
void TabbedMainWindow::init()
{
	QSettings settings;
	QStringList lst = settings.value("cmdStatistics").toStringList();
	foreach(const QString &text, lst) {
		QStringList kv = text.split(":");
		if( kv.size() == 2 )
			g_cmdStatistics.insert(kv[0], (uint)kv[1].toInt());
	}
	setAcceptDrops(true);
	m_settings = new Settings();

	m_tabWidget = new QTabWidget;
	m_tabWidget->setMovable(true);
	m_tabWidget->setTabsClosable(true);
	connect(m_tabWidget, SIGNAL(tabCloseRequested(int)), this, SLOT(tabCloseRequested(int)));
	connect(m_tabWidget, SIGNAL(currentChanged(int)), this, SLOT(onTabChanged(int)));
	setCentralWidget(m_tabWidget);
}
