/*

	Copyright (C) 2012 by Nobuhide Tsuda

	RuviEdit ̃CZX MIT{GPL ȃCZXłB 
	ۏ؁ET|[głAŗpłApAvł\[XR[h𗬗p邱Ƃ\łB 
	i\[XR[h𗬗pꍇAp̒쌠ECZXRuviEdit̂̂܂܂łj 
	M҂́AvO}ɂƂĕsRɂ܂Ȃ̂ɎRRƌGPLnȂ̂ŁA 
	RuviEdit ̃\[XGPLnvWFNgŎgp邱Ƃ֎~܂B 
	GPLvWFNgł͈؂̗p֎~܂ALGPLvWFNgł͓INɂ闬p͋܂B

*/
#include <QtGui>
#include "CompletionWidget.h"

typedef const char cchar;

struct KeywordsItem
{
	bool	m_pseudoVar;
	cchar	*m_text;
	cchar	*m_desc;
};
KeywordsItem keywords[] = {
	{false,	"BEGIN",	"BEGIN { ... }"},
	{false,	"END",		"END { ... }"},
	{false,	"alias",	"alias <new method name> <old method name>"},
	{false,	"and",		"if <exp> and <exp> then ..."},
	{false,	"attr_accessor",	"attr_accessor :<var>, :<var>..."},
	{false,	"attr_reader",		"attr_reader :<var>, :<var>..."},
	{false,	"attr_writer",		"attr_writer :<var>, :<var>..."},
	{false,	"begin",	"begin ... rescue ... ensure ... end"},
	{false,	"break",	"while <exp> break if <exp> end"},
	{false,	"case",		"case <exp> when <exp> ... end"},
	{false,	"class",	"class <ident> [< super]... end"},
	{false,	"def",		"def <function name> ... end"},
	{false,	"defined?",	""},
	{false,	"do",		""},
	{false,	"each",		""},
	{false,	"else",		"if <exp> [then] ... else ... end"},
	{false,	"elsif",	"if <exp> [then] ... elsif <exp> ... end"},
	{false,	"end",		""},
	{false,	"ensure",	""},
	{true,	"false",	""},
	{false,	"for",		""},
	{false,	"if",		"if <exp> then <statement> end, or <statement> if exp"},
	{false,	"in",		"for <lhs> in <exp> ... end"},
	{false,	"module",	""},
	{false,	"next",		""},
	{true,	"nil",		""},
	{false,	"not",		""},
	{false,	"or",		""},
	{false,	"private",	"private :<var>"},
	{false,	"protected","protected :<var>"},
	{false,	"public",	"public :<var>"},
	{false,	"redo",		""},
	{false,	"require",	"requie '<file name>'"},
	{false,	"rescue",	""},
	{false,	"retry",	""},
	{false,	"return",	""},
	{true,	"self",		""},
	{false,	"super",	""},
	{false,	"then",		"if <exp> then ... end"},
	{true,	"true",		""},
	{false,	"undef",	""},
	{false,	"unless",	"unless <exp> ... end"},
	{false,	"until",	"until <exp> [do] ... end"},
	{false,	"when",		"case <exp> when <exp>.... end"},
	{false,	"while",	"while <exp> [do] ... end"},
	{false,	"yield",	""},
	{true,	"__LINE__",		""},
	{true,	"__FILE__",		""},
	{true,	"__ENCODING__",	""},
	{false,	0, 0},
};

CompletionWidget::CompletionWidget(QTextEdit *editor,
									const QStringList &candidates,	//	⊮AȂ΃L[[h⊮
									QString text,		//	J[\OeLXg
									QWidget *parent)
	: QDialog(parent, Qt::FramelessWindowHint)
	, m_editor(editor)
	, m_candidates(candidates)
	, m_text(text)
{
	QVBoxLayout *layout = new QVBoxLayout;
	setLayout(layout);
	layout->setContentsMargins(0, 0, 0, 0);
#if 0
	m_treeWidget = new QTreeWidget;
	layout->addWidget(m_treeWidget);
	//m_treeWidget->setColumnCount(2);
	//m_treeWidget->setColumnWidth(0, 100);
	m_treeWidget->setHeaderHidden(true);	//	wb_\
	setupCandidates();
	m_treeWidget->setCurrentItem(m_treeWidget->itemAt(0, 0));	//	ŏ̃ACeI
#else
	m_listWidget = new QListWidget;
	layout->addWidget(m_listWidget);
	int k = setupCandidates();
	m_listWidget->setCurrentRow(k);
	m_listWidget->installEventFilter(this);
	//m_listWidget->setAttribute(Qt::WA_AlwaysShowToolTips);
	//m_listWidget->setSizePolicy( QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Maximum));
	connect(m_listWidget, SIGNAL(currentRowChanged(int)), this, SLOT(currentRowChanged(int)));
#endif
	QListWidgetItem *item = m_listWidget->item(k);
	QRect rect = m_listWidget->visualItemRect(item);
	const int nht = rect.height() * (m_listWidget->count() + 1);
	if( height() > nht )
		resize(240, nht);
	//setSizePolicy( QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Maximum));
	setAttribute(Qt::WA_TranslucentBackground);

	//currentRowChanged(k);		12/05/09 ̂\Ȃ
}

CompletionWidget::~CompletionWidget()
{

}
void CompletionWidget::currentRowChanged(int ix)
{
	if( ix < 0 ) return;
	QListWidgetItem *item = m_listWidget->item(ix);
	QRect rect = m_listWidget->visualItemRect(item);
	QPoint gp = m_listWidget->mapToGlobal(QPoint(rect.right(), rect.y() - rect.height()));
	QToolTip::showText(gp, item->toolTip());
#if 0
	QHelpEvent *event = new QHelpEvent(QEvent::ToolTip,
                                       QPoint(0, 0),
                                       QPoint(gp.x(), gp.y()));  

    QApplication::postEvent(m_listWidget, event);
#endif
}
#if 0
void CompletionWidget::currentItemChanged(QListWidgetItem *item)
{
}
#endif
int CompletionWidget::setupCandidates()
{
	m_listWidget->clear();
	QListWidgetItem *item = 0;
	int i = 0;
	int k = 0;
	if( m_candidates.isEmpty() ) {
		for(int ix = 0; keywords[ix].m_text != 0; ++ix) {
			QString kw(keywords[ix].m_text);
			if( !m_text.isEmpty() && !kw.startsWith(m_text) )
				continue;
			item = new QListWidgetItem(kw);
			item->setToolTip(keywords[ix].m_desc);
			//item->setAttribute(WA_AlwaysShowToolTips);
			m_listWidget->insertItem(i++, item);
		}
	} else {
		foreach(const QString cText, m_candidates) {
			if( cText.startsWith(m_text) ) {
				if( cText == m_text ) k = i;
				item = new QListWidgetItem(cText);
				m_listWidget->insertItem(i++, item);
			}
		}
		//if( k >= 0 )
		//	m_listWidget->setCurrentRow(k);
	}
	if( !m_listWidget->count() ) {
		reject();
		return 0;
	}
#if 0	//	삵Ȃ̂ŁAƂ肠RgAEg 12/04/04
	if( item != 0 && m_listWidget->count() < 8 ) {
		//int ht0 = item->sizeHint().height();
		int ht = QFontMetrics(item->font()).height();	//	1ACe
		//QSize gs = m_listWidget->gridSize();
		QSize sz = size();
		sz.setHeight(ht * m_listWidget->count());
		resize(sz);
	}
#endif
	if( k > 0 ) --k;
	return k;
}
#if 0
void CompletionWidget::accept()
{
}
#endif
int CompletionWidget::count() const
{
	return m_listWidget->count();
}
QString CompletionWidget::text() const
{
#if 0
	QList<QTreeWidgetItem *> lst = m_treeWidget->selectedItems();
	if( lst.isEmpty() ) return QString();
	QTreeWidgetItem *item = lst[0];
	return item->text(0);
#else
	QList<QListWidgetItem *> lst = m_listWidget->selectedItems();
	if( lst.isEmpty() ) return QString();
	QListWidgetItem *item = lst[0];
	return item->text();
#endif
}
bool CompletionWidget::eventFilter ( QObject * obj, QEvent * event )
{
	if( obj == m_listWidget && event->type() == QEvent::KeyPress ) {
		QKeyEvent *keyEvent = static_cast<QKeyEvent*>(event);
		//if( keyEvent->key() != Qt::Key_Return ) {
			QString text = keyEvent->text();
			if( !text.isEmpty() && text[0].unicode() >= 0x21 && text[0].unicode() <= 0x7f ) {
				m_editor->textCursor().insertText(text);
				m_text += text;
				setupCandidates();
				if( !m_listWidget->count() )
					reject();
				else {
					m_listWidget->setCurrentRow(0);
					if( m_listWidget->count() == 1 )
						accept();
				}
				return true;
			}
		//}
	}
	return false;
}
void CompletionWidget::keyPressEvent ( QKeyEvent * event )
{
	const bool ctrl = (event->modifiers() & Qt::ControlModifier) != 0;
	const bool shift = (event->modifiers() & Qt::ShiftModifier) != 0;
	const bool alt = (event->modifiers() & Qt::AltModifier) != 0;
	if( event->key() == Qt::Key_Return ) {
		accept();
		return;
	}
	if( event->key() == Qt::Key_Escape ) {
		reject();
		return;
	}
	if( event->key() == Qt::Key_Backspace ) {
		done('\b');
		return;
	}
	if( ctrl && !shift && !alt ) {
		if( event->key() == Qt::Key_K || event->key() == Qt::Key_L ) {
			int ix = m_listWidget->currentRow();
			if( ix != 0 )
				m_listWidget->setCurrentRow(ix - 1);
			return;
		}
		if( event->key() == Qt::Key_J ) {
			int ix = m_listWidget->currentRow();
			if( ++ix < m_listWidget->count() )
				m_listWidget->setCurrentRow(ix);
			return;
		}
	}
#if 0
	QString text = event->text();
	if( text.isEmpty() ) return;
	m_text += text;
	setupCandidates();
	m_listWidget->setCurrentRow(0);
#endif
}
