# -*- coding: utf-8 -*-
#   Copyright 2009 Agile42 GmbH, Berlin (Germany)
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.
#   
#   Author: 
#       - Felix Schwarz <felix.schwarz__at__agile42.com>

import urllib2

from trac.perm import PermissionSystem
from trac.tests.functional import tc
from trac.util.datefmt import to_timestamp

from agilo.utils import Action
from agilo.test import Usernames
from agilo.test.functional import AgiloTestCase


class TicketPageInjectsCustomHeaderForTicketID(AgiloTestCase):
    
    def setUp(self):
        super(TicketPageInjectsCustomHeaderForTicketID, self).setUp()
        self._grant_ticket_admin_to_anonymous()
    
    def tearDown(self):
        tracenv = self.testenv.get_trac_environment()
        PermissionSystem(tracenv).revoke_permission('anonymous', Action.TRAC_ADMIN)
        super(TicketPageInjectsCustomHeaderForTicketID, self).tearDown()
    
    def _grant_ticket_admin_to_anonymous(self):
        # twill does not allow us to access the response headers. Therefore we
        # need to utilize urllib2 directly which has the downside that we can
        # not access the ticket edit page by default.
        tracenv = self.testenv.get_trac_environment()
        PermissionSystem(tracenv).grant_permission('anonymous', Action.TRAC_ADMIN)
        # fs: Somehow we need to restart the tracd - otherwise tracd will not
        # 'see' the granted permissions even though I can verify with sqlite3
        # that they are really stored in the db...
        tracenv = self.testenv.get_trac_environment()
        tracenv.config.touch()
    
    def _extract_ticket_id_from_header(self, task_id, edit_page=False):
        url = self.tester.ticket_url(task_id, edit=edit_page)
        response = urllib2.urlopen(url)
        return response.headers.getheader('X-Agilo-Ticket-ID')
    
    def runTest(self):
        self.tester.login_as(Usernames.team_member)
        task_id = self.tester.create_new_agilo_task('Foo')
        self.assertEqual(str(task_id), self._extract_ticket_id_from_header(task_id))
        self.assertEqual(str(task_id), self._extract_ticket_id_from_header(task_id, edit_page=True))


class TicketModuleAcceptsAlsoTimestampsForLastChangedTimeTest(AgiloTestCase):
    
    def runTest(self):
        self.tester.login_as(Usernames.team_member)
        task_id = self.tester.create_new_agilo_task('Foo')
        
        last_change = self.tester.get_time_of_last_change(task_id)
        self.tester.edit_ticket(task_id, summary='fnord', ts='12')
        tc.find('This ticket has been modified by someone else since you started')
        
        self.tester.edit_ticket(task_id, summary='fnord', ts=to_timestamp(last_change))
        tc.notfind('This ticket has been modified by someone else since you started')
        tc.find('fnord')



if __name__ == '__main__':
    from agilo.test.testfinder import run_all_tests
    run_all_tests(__file__)

