/*
 * 確認ダイアログ
 *
 * message      : ダイアログのメッセージ本文
 * title        : ダイアログのタイトル
 * buttonok     : OKボタンのテキスト
 * buttoncancel : キャンセルボタンのテキスト
 * response     : コールバック関数を指定する。引数 cancel にボタン選択の結果が入る。
 *                OK ならば false キャンセルならば true となる。
 */
function informDialog(message, title, buttonok, buttoncancel, response) {
	var _dlg = $('<div>' + message + '</div>');
	var _buttons = {};
	_buttons[buttoncancel] = function() {
		$(this).dialog('close');
		response(true)
	};
	_buttons[buttonok] = function() {
		$(this).dialog('close');
		response(false)
	};

	_dlg.dialog( {
		modal : true,
		draggable : false,
		title : title,
		height : 130,
		width : 320,
		buttons : _buttons,
		overlay : {
			opacity : 0.5,
			background : '#000000'
		}

	});
}

var iic = function informInputCheck() {
	if (this.checked) {
		$("#inform_input_data").show("normal");
	} else {
		$("#inform_input_data").hide("normal");
	}
}
function informInputCheckLoad() {
	$("#inform").click(iic);
	if(!$("#inform").attr("checked")){
		$("#inform_input_data").hide();
	}
}
