# -*- coding: utf-8 -*-

import sys
import os
import re
import unittest

script_dir = os.path.dirname(os.path.abspath(__file__))
base_dir = script_dir + os.sep + '../'
if not base_dir in sys.path:
    sys.path.insert(0, base_dir)
    
from renderer import ReportRenderer
    
class ComponentManagerStub(object):
    components = {}

    def component_activated(self, dummy):
        pass

    def get_db_cnx(self):
        return DBStub()
    
class RequestStub(object):
    def __init__(self):
        self.href = HrefStub()
        self.tz = None
    
class HrefStub(object):
    def worktime(self, id):
        return 'worktime/%s' % id
  
class ConfigStub(object):
    def get(self, tag, key):
        pass

class DBStub(object):
    def __init__(self, row=None):
        self.row = row
    
    def cursor(self):
        print "cursor"
        return self
    
    def execute(self, sql , args):
        print "excecute"
        return self
    
    def fetchone(self):
        print "fetchone"
        return self.row 
    
    def commit(self):
        print "commit"
        
class RendererTest(unittest.TestCase):

    def setUp(self):
        self.env = ComponentManagerStub()
        self.req = RequestStub()
        self.db = DBStub()
    
    def test_getXAxisType(self):
        renderer = ReportRenderer(self.env)
        
        type = renderer._getXAxisType(self.req, ['2011-04-31'], [])
        self.assertEqual("string", type)
        
        type = renderer._getXAxisType(self.req, ['2011-04-30'], [])
        self.assertEqual("date", type)
        
        type = renderer._getXAxisType(self.req, [100, 110], [])
        self.assertEqual("number", type)
        
        type = renderer._getXAxisType(self.req, ["100", "110"], [])
        self.assertEqual("number", type)
    
    def test_to_js_array(self):
        renderer = ReportRenderer(self.env)
        
        result = renderer._to_js_array([1, 2, 3])
        self.assertEqual("[1,2,3]", result)
        
        result = renderer._to_js_array([1, 'a', 3])
        self.assertEqual("['1','a','3']", result)
        
        result = renderer._to_js_array([])
        self.assertEqual("[]", result)
        
        result = renderer._to_js_array(None)
        self.assertEqual("null", result)
    
    def test_convert_col(self):
        renderer = ReportRenderer(self.env)
        
        col = renderer._convert_col(self.req, 'test', '1')
        self.assertEqual('1', col)
        
        col = renderer._convert_col(self.req, '時刻', '100000')
        self.assertEqual('12:46:40', col)
        
        col = renderer._convert_col(self.req, '日付', '100000')
        self.assertEqual('1970/01/02', col)
        
        col = renderer._convert_col(self.req, '日時', '100000')
        self.assertEqual('1970/01/02 12:46:40', col)
        
        col = renderer._convert_col(self.req, 'time', '100000')
        self.assertEqual('12:46:40', col)
        
        col = renderer._convert_col(self.req, 'date', '100000')
        self.assertEqual('1970/01/02', col)
        
        col = renderer._convert_col(self.req, 'datetime', '100000')
        self.assertEqual('1970/01/02 12:46:40', col)
        
        def ticket(id):
            return '/ticket/%s' % id
        self.req.href.ticket = ticket
        
        col = renderer._convert_col(self.req, 'ticket', '100')
        self.assertEqual('<a class="ticket" href="/ticket/100" title="View Ticket">#100</a>',
                          str(col))
        
        col = renderer._convert_col(self.req, 'id', '100')
        self.assertEqual('<a class="ticket" href="/ticket/100" title="View Ticket">#100</a>',
                          str(col))
        
        col = renderer._convert_col(self.req, 'チケット', '100')
        self.assertEqual('<a class="ticket" href="/ticket/100" title="View Ticket">#100</a>',
                          str(col))
        

if __name__ == '__main__':
    unittest.main()

