﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Runtime.Serialization;
using SharpDX.DirectWrite;
using FDK;
using FDK.メディア;
using SST.曲;

namespace SST.設定
{
	/// <summary>
	///		SSTユーザ情報の定義。
	/// </summary>
	/// <remarks>
	///		SSTユーザは Windowsログオンユーザとは別物だが、SSTユーザは、SSTを実行しているときの Windows ログオンユーザに対して作成されるので注意。
	/// </remarks>
	class ユーザ : Activity
	{
		/// <summary>
		///		このユーザの基本情報。
		/// </summary>
		public ユーザプロパティ プロパティ { get; set; }

		/// <summary>
		///		このユーザのオプション設定。
		/// </summary>
		public オプション設定 オプション設定 { get; set; }

		public 画像 写真 { get; set; }

		public 文字列画像 名前画像 { get; set; }

		/// <summary>
		///		このユーザが持つ曲ツリー。
		///	</summary>
		public 曲ツリー 曲ツリー { get; }


		public ユーザ()
		{
			this.プロパティ = new ユーザプロパティ();
			this.オプション設定 = new オプション設定();
			this.写真 = null;
			this.名前画像 = null;

			// 静的子Activityを追加。

			this.子リスト.Add( this.曲ツリー = new 曲ツリー() );
		}

		public ユーザ( string 名前 )
			: this()
		{
			this.プロパティ.名前 = 名前;
		}

		protected override void On活性化( グラフィックデバイス gd )
		{
			// 動的子Activityを追加。

			if( this.プロパティ.写真パス.Nullでも空でもない() )
				this.子リスト.Add( this.写真 = new 画像( Path.Combine( SST.IO.Folder.User( this.プロパティ.名前 ), this.プロパティ.写真パス ) ) );

			this.子リスト.Add( this.名前画像 = new 文字列画像() { フォント名 = this.プロパティ.名前, フォント幅 = FontWeight.Bold, フォントサイズpt = 90f } );
		}

		protected override void On非活性化( グラフィックデバイス gd )
		{
			// 動的子Activityを削除。

			if( null != this.写真 )
				this.子リスト.Remove( this.写真 );

			this.子リスト.Remove( this.名前画像 );
		}

		/// <summary>
		///		現在の曲ツリーをクリアし、<see cref="ユーザプロパティ.曲検索フォルダパスリスト"/>に従って、曲ツリーを新しく再構築する。
		/// </summary>
		public void 曲ツリーを再構築する()
		{
			this.曲ツリー.すべてのノードを削除する();

			foreach( var path in this.プロパティ.曲検索フォルダパスリスト )
				this.曲ツリー.曲を検索して親ノードに追加する( this.曲ツリー.ルートノード, path );
		}


		/// <summary>
		///		ファイルに保存する。
		/// </summary>
		public void 保存する()
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
				var ユーザフォルダパス = SST.IO.Folder.User( this.プロパティ.名前 );

				if( false == Directory.Exists( ユーザフォルダパス ) )
					Directory.CreateDirectory( ユーザフォルダパス ); // 失敗したら例外発生。

				// プロパティを保存。
				FDKUtilities.保存する( this.プロパティ, Path.Combine( ユーザフォルダパス, _Propertiesファイル名 ) );

				// オプション設定を保存。
				this.オプション設定.保存する( ユーザフォルダパス );
			}
		}

		/// <summary>
		///		ファイルから復元する。
		///		曲リストは復元しない。
		/// </summary>
		/// <param name="ユーザフォルダパス">ユーザフォルダのパス。ユーザ名の部分は、ファイル名やパスで使える文字に調整済みであること。</param>
		public static ユーザ 復元する( string ユーザフォルダパス )
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
				var user = new ユーザ( "" );
				user.プロパティ = FDKUtilities.復元する<ユーザプロパティ>( Path.Combine( ユーザフォルダパス, _Propertiesファイル名 ) );
				user.オプション設定 = オプション設定.復元する( ユーザフォルダパス );
				return user;
			}
		}


		/// <summary>
		///		ユーザを保存するファイルのパス。
		///		ユーザルートからの相対パスで指定する。
		/// </summary>
		internal static readonly string _Propertiesファイル名 = @"Properties.json";
	}
}
