using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;

namespace TDCG
{
    /// <summary>
    /// TSOFileo\bhQ
    /// </summary>
    public class TSOWriter
    {
        /// <summary>
        /// w胉C^  'TSO1' o܂B
        /// </summary>
        /// <param name="bw">C^</param>
        public static void WriteMagic(BinaryWriter bw)
        {
            bw.Write(0x314F5354);
        }

        /// <summary>
        /// w胉C^bytezo܂B
        /// </summary>
        /// <param name="bw">C^</param>
        /// <param name="bytes">bytez</param>
        public static void Write(BinaryWriter bw, byte[] bytes)
        {
            bw.Write(bytes);
        }

        /// <summary>
        /// w胉C^nullI[o܂B
        /// </summary>
        /// <param name="bw">C^</param>
        /// <param name="s"></param>
        public static void Write(BinaryWriter bw, string s)
        {
            foreach(byte i in Encoding.Default.GetBytes(s))
                bw.Write(i);

            bw.Write((byte)0);
        }

        /// <summary>
        /// w胉C^nodezo܂B
        /// </summary>
        /// <param name="bw">C^</param>
        /// <param name="items">nodez</param>
        public static void Write(BinaryWriter bw, TSONode[] items)
        {
            bw.Write(items.Length);

            foreach(var i in items)
                Write(bw, i);

            bw.Write(items.Length);

            Matrix m = Matrix.Identity;
            foreach (var i in items)
            {
                m = i.TransformationMatrix;
                Write(bw, ref m);
            }
        }

        /// <summary>
        /// w胉C^nodeo܂B
        /// </summary>
        /// <param name="bw">C^</param>
        /// <param name="item">node</param>
        public static void Write(BinaryWriter bw, TSONode item)
        {
            Write(bw, item.Name);
        }

        /// <summary>
        /// w胉C^ɃeNX`zo܂B
        /// </summary>
        /// <param name="bw">C^</param>
        /// <param name="items">eNX`z</param>
        public static void Write(BinaryWriter bw, TSOTex[] items)
        {
            bw.Write(items.Length);

            foreach(var i in items)
                Write(bw, i);
        }

        /// <summary>
        /// w胉C^ɃeNX`o܂B
        /// </summary>
        /// <param name="bw">C^</param>
        /// <param name="item">eNX`</param>
        public static void Write(BinaryWriter bw, TSOTex item)
        {
            Write(bw, item.name);
            Write(bw, item.file);
            bw.Write(item.width);
            bw.Write(item.height);
            bw.Write(item.depth);
            Write(bw, item.data);
        }

        /// <summary>
        /// w胉C^ɍso܂B
        /// </summary>
        /// <param name="bw">C^</param>
        /// <param name="m">s</param>
        public static void Write(BinaryWriter bw, ref Matrix m)
        {
            bw.Write(m.M11); bw.Write(m.M12); bw.Write(m.M13); bw.Write(m.M14);
            bw.Write(m.M21); bw.Write(m.M22); bw.Write(m.M23); bw.Write(m.M24);
            bw.Write(m.M31); bw.Write(m.M32); bw.Write(m.M33); bw.Write(m.M34);
            bw.Write(m.M41); bw.Write(m.M42); bw.Write(m.M43); bw.Write(m.M44);
        }
    }
}
