/*
 * Decompiled with CFR 0.152.
 */
package servletunit;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import servletunit.HttpSessionSimulator;
import servletunit.ServletContextSimulator;

public class HttpServletRequestSimulator
implements HttpServletRequest {
    private Hashtable attributes = new Hashtable();
    private String scheme = "http";
    private String protocol = "HTTP/1.1";
    private String requestURI;
    private String requestURL;
    private String contextPath = "";
    private String servletPath;
    private String pathInfo;
    private String queryString;
    private String method;
    private String contentType;
    private Locale locale;
    private Principal principal;
    String remoteAddr;
    String remoteHost;
    private String remoteUser;
    private String userRole;
    private String reqSessionId;
    String authType;
    String charEncoding;
    private String serverName;
    private int port;
    private Hashtable parameters = new Hashtable();
    private Hashtable headers = new Hashtable();
    private Vector cookies = new Vector();
    private HttpSession session;
    private ServletContext context;
    public static final int GET = 0;
    public static final int POST = 1;
    public static final int PUT = 2;

    public HttpServletRequestSimulator(ServletContext context) {
        this.context = context;
    }

    public void addParameter(String key, String value) {
        if (key != null && value != null) {
            this.parameters.put(key, value);
        }
    }

    public void addParameter(String name, String[] values) {
        if (name != null && values != null) {
            this.parameters.put(name, values);
        }
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    public Object getAttribute(String s) {
        return this.attributes.get(s);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getCharacterEncoding() {
        return this.charEncoding;
    }

    public int getContentLength() {
        return -1;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void addCookie(Cookie cookie) {
        this.cookies.addElement(cookie);
    }

    public void setCookies(Cookie[] cookies) {
        for (int i = 0; i < cookies.length; ++i) {
            this.cookies.addElement(cookies[i]);
        }
    }

    public Cookie[] getCookies() {
        if (this.cookies.isEmpty()) {
            return null;
        }
        Cookie[] cookieArray = new Cookie[this.cookies.size()];
        return this.cookies.toArray(cookieArray);
    }

    public long getDateHeader(String name) {
        String s1 = this.getHeader(name);
        if (s1 == null) {
            return -1L;
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat();
            return dateFormat.parse(s1).getTime();
        }
        catch (ParseException exception) {
            throw new IllegalArgumentException("Cannot parse date: " + s1);
        }
    }

    public String getHeader(String s) {
        return (String)this.headers.get(s);
    }

    public Enumeration getHeaderNames() {
        return this.headers.keys();
    }

    public Enumeration getHeaders(String s) {
        throw new UnsupportedOperationException("getHeaders operation is not supported!");
    }

    public ServletInputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException("getInputStream operation is not supported!");
    }

    public int getIntHeader(String s) {
        Object header = this.headers.get(s);
        if (header != null) {
            try {
                Integer intHeader = (Integer)header;
                return intHeader;
            }
            catch (ClassCastException e) {
                throw new NumberFormatException("header '" + s + "' cannot be converted to number format.");
            }
        }
        return -1;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.US;
        }
        return this.locale;
    }

    public Enumeration getLocales() {
        return Collections.enumeration(Collections.singleton(this.getLocale()));
    }

    public String getMethod() {
        if (this.method == null) {
            return "POST";
        }
        return this.method;
    }

    public String getParameter(String s) {
        if (s == null) {
            return null;
        }
        Object param = this.parameters.get(s);
        if (null == param) {
            return null;
        }
        if (param.getClass().isArray()) {
            return ((String[])param)[0];
        }
        return (String)param;
    }

    public Enumeration getParameterNames() {
        return this.parameters.keys();
    }

    public String[] getParameterValues(String s) {
        if (s == null) {
            return null;
        }
        Object param = this.parameters.get(s);
        if (null == param) {
            return null;
        }
        if (param.getClass().isArray()) {
            return (String[])param;
        }
        return new String[]{(String)param};
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        throw new UnsupportedOperationException("getPathTranslated operation is not supported!");
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public BufferedReader getReader() throws IOException {
        throw new UnsupportedOperationException("getReader operation is not supported!");
    }

    public String getRealPath(String path) {
        File contextDirectory = ((ServletContextSimulator)this.context).getContextDirectory();
        if (contextDirectory == null || path == null) {
            return null;
        }
        return new File(contextDirectory, path).getAbsolutePath();
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public RequestDispatcher getRequestDispatcher(String url) {
        return this.context.getRequestDispatcher(url);
    }

    public String getRequestedSessionId() {
        return this.reqSessionId;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.requestURL);
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.port;
    }

    public void setServerPort(int port) {
        this.port = port;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean b) {
        if (this.session == null && b) {
            this.session = new HttpSessionSimulator(this.context);
        } else if (this.session != null && !((HttpSessionSimulator)this.session).isValid() && b) {
            this.session = new HttpSessionSimulator(this.context);
        }
        if (this.session != null && ((HttpSessionSimulator)this.session).isValid()) {
            return this.session;
        }
        return null;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return true;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        if (this.session != null) {
            try {
                this.session.getId();
                return true;
            }
            catch (IllegalStateException e) {
                return false;
            }
        }
        return false;
    }

    public boolean isSecure() {
        if (this.scheme == null) {
            return false;
        }
        return this.scheme.equalsIgnoreCase("HTTPS");
    }

    public boolean isUserInRole(String s) {
        return s.equals(this.userRole);
    }

    public void setUserRole(String role) {
        this.userRole = role;
    }

    public void removeAttribute(String s) {
        this.attributes.remove(s);
    }

    public void setAttribute(String name, Object o) {
        if (o == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, o);
        }
    }

    public void setAuthType(String s) {
        this.authType = s;
    }

    public void setCharacterEncoding(String s) {
        this.charEncoding = s;
    }

    public void setContentType(String s) {
        this.contentType = s;
    }

    public void setHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void setMethod(int methodType) {
        switch (methodType) {
            case 0: {
                this.method = "GET";
                break;
            }
            case 2: {
                this.method = "PUT";
                break;
            }
            case 1: {
                this.method = "POST";
                break;
            }
            default: {
                this.method = "POST";
            }
        }
    }

    public void setParameterValue(String key, String[] value) {
        this.parameters.put(key, value);
    }

    public void setPathInfo(String s) {
        this.pathInfo = s;
    }

    public void setQueryString(String s) {
        this.queryString = s;
    }

    public void setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public void setRequestedSessionId(String s) {
        this.reqSessionId = s;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public void setRequestURL(String url) {
        int queryIndex = url.lastIndexOf(63);
        if (queryIndex < 0) {
            queryIndex = url.length();
        }
        this.requestURL = url.substring(0, queryIndex);
        if (queryIndex != url.length()) {
            this.setQueryString(url.substring(queryIndex + 1));
        }
        int schemeIndex = url.lastIndexOf("://");
        this.setScheme(url.substring(0, schemeIndex));
        this.setRequestURI(url.substring(url.indexOf(47, schemeIndex + 3), queryIndex));
        int portIndex = url.indexOf(58, schemeIndex + 2);
        if (portIndex > 0) {
            this.setServerName(url.substring(schemeIndex + 3, portIndex));
            this.setServerPort(Integer.parseInt(url.substring(portIndex + 1, url.indexOf(47, schemeIndex + 3))));
        } else {
            this.setServerName(url.substring(schemeIndex + 3, url.indexOf(47, schemeIndex + 3)));
            if (this.isSecure()) {
                this.setServerPort(443);
            } else {
                this.setServerPort(80);
            }
        }
    }

    public void setScheme(String s) {
        this.scheme = s;
    }

    public void setServletPath(String s) {
        this.servletPath = s;
    }

    public void setServerName(String s) {
        this.serverName = s;
    }

    public void setContextPath(String s) {
        this.contextPath = s;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setUserPrincipal(Principal principal) {
        this.principal = principal;
    }
}

